/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.remote.MetaDataOperation;
import org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.remote.TypedValue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProtobufTranslationImplTest<T> {
    private final T object;
    private final IdentityFunction<T> function;

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ProtobufTranslationImpl translation = new ProtobufTranslationImpl();
        RequestFunc requestFunc = new RequestFunc((ProtobufTranslation)translation);
        ResponseFunc responseFunc = new ResponseFunc((ProtobufTranslation)translation);
        List<Service.Request> requests = ProtobufTranslationImplTest.getRequests();
        List<Service.Request> requestsWithNulls = ProtobufTranslationImplTest.getRequestsWithNulls();
        List<Service.Response> responses = ProtobufTranslationImplTest.getResponses();
        for (Service.Request request : requests) {
            params.add(new Object[]{request, requestFunc});
        }
        for (Service.Request request : requestsWithNulls) {
            params.add(new Object[]{request, requestFunc});
        }
        for (Service.Response response : responses) {
            params.add(new Object[]{response, responseFunc});
        }
        return params;
    }

    private static List<Service.Request> getRequests() {
        LinkedList<Service.Request> requests = new LinkedList<Service.Request>();
        requests.add((Service.Request)new Service.CatalogsRequest());
        requests.add((Service.Request)new Service.DatabasePropertyRequest());
        requests.add((Service.Request)new Service.SchemasRequest("connectionId", "catalog", "schemaPattern"));
        requests.add((Service.Request)new Service.TablesRequest("connectionId", "catalog", "schemaPattern", "tableNamePattern", Arrays.asList("STRING", "BOOLEAN", "INT")));
        requests.add((Service.Request)new Service.TableTypesRequest());
        requests.add((Service.Request)new Service.ColumnsRequest("connectionId", "catalog", "schemaPattern", "tableNamePattern", "columnNamePattern"));
        requests.add((Service.Request)new Service.TypeInfoRequest());
        requests.add((Service.Request)new Service.PrepareAndExecuteRequest("connectionId", Integer.MAX_VALUE, "sql", Long.MAX_VALUE));
        requests.add((Service.Request)new Service.PrepareRequest("connectionId", "sql", Long.MAX_VALUE));
        List<TypedValue> paramValues = Arrays.asList(TypedValue.create((String)ColumnMetaData.Rep.BOOLEAN.name(), (Object)Boolean.TRUE), TypedValue.create((String)ColumnMetaData.Rep.STRING.name(), (Object)"string"));
        Service.FetchRequest fetchRequest = new Service.FetchRequest("connectionId", Integer.MAX_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE);
        requests.add((Service.Request)fetchRequest);
        requests.add((Service.Request)new Service.CreateStatementRequest("connectionId"));
        requests.add((Service.Request)new Service.CloseStatementRequest("connectionId", Integer.MAX_VALUE));
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("param1", "value1");
        info.put("param2", "value2");
        requests.add((Service.Request)new Service.OpenConnectionRequest("connectionId", info));
        requests.add((Service.Request)new Service.CloseConnectionRequest("connectionId"));
        requests.add((Service.Request)new Service.ConnectionSyncRequest("connectionId", (Meta.ConnectionProperties)new ConnectionPropertiesImpl(Boolean.FALSE, Boolean.FALSE, Integer.valueOf(Integer.MAX_VALUE), "catalog", "schema")));
        requests.add((Service.Request)new Service.SyncResultsRequest("connectionId", 12345, ProtobufTranslationImplTest.getSqlQueryState(), 150L));
        requests.add((Service.Request)new Service.SyncResultsRequest("connectionId2", 54321, ProtobufTranslationImplTest.getMetadataQueryState1(), 0L));
        requests.add((Service.Request)new Service.SyncResultsRequest("connectionId3", 5, ProtobufTranslationImplTest.getMetadataQueryState2(), 10L));
        return requests;
    }

    private static QueryState getSqlQueryState() {
        return new QueryState("SELECT * from TABLE");
    }

    private static QueryState getMetadataQueryState1() {
        return new QueryState(MetaDataOperation.GET_COLUMNS, new Object[]{"", null, "%", "%"});
    }

    private static QueryState getMetadataQueryState2() {
        return new QueryState(MetaDataOperation.GET_CATALOGS, new Object[0]);
    }

    private static List<Service.Request> getRequestsWithNulls() {
        LinkedList<Service.Request> requests = new LinkedList<Service.Request>();
        requests.add((Service.Request)new Service.SchemasRequest(null, null, null));
        requests.add((Service.Request)new Service.TablesRequest(null, null, null, null, Collections.emptyList()));
        requests.add((Service.Request)new Service.ColumnsRequest(null, null, null, null, null));
        requests.add((Service.Request)new Service.PrepareAndExecuteRequest(null, 0, null, 0L));
        requests.add((Service.Request)new Service.PrepareRequest(null, null, 0L));
        requests.add((Service.Request)new Service.CreateStatementRequest(null));
        requests.add((Service.Request)new Service.CloseStatementRequest(null, 0));
        requests.add((Service.Request)new Service.OpenConnectionRequest(null, null));
        requests.add((Service.Request)new Service.CloseConnectionRequest(null));
        requests.add((Service.Request)new Service.ConnectionSyncRequest(null, null));
        return requests;
    }

    private static List<Service.Response> getResponses() {
        LinkedList<Service.Response> responses = new LinkedList<Service.Response>();
        List<ColumnMetaData> columns = Arrays.asList(MetaImpl.columnMetaData((String)"str", (int)0, String.class), MetaImpl.columnMetaData((String)"count", (int)1, Integer.class));
        List<AvaticaParameter> params = Arrays.asList(new AvaticaParameter(false, 10, 0, 12, "VARCHAR", String.class.getName(), "str"));
        Meta.CursorFactory cursorFactory = Meta.CursorFactory.create((Meta.Style)Meta.Style.LIST, Object.class, Arrays.asList("str", "count"));
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        rows.add(new Object[]{"str_value", 50});
        Meta.Signature signature = Meta.Signature.create(columns, (String)"sql", params, (Meta.CursorFactory)cursorFactory, (Meta.StatementType)Meta.StatementType.SELECT);
        Meta.Frame frame = Meta.Frame.create((int)Integer.MAX_VALUE, (boolean)true, rows);
        Service.ResultSetResponse results1 = new Service.ResultSetResponse("connectionId", Integer.MAX_VALUE, true, signature, frame, Long.MAX_VALUE);
        responses.add((Service.Response)results1);
        responses.add((Service.Response)new Service.CloseStatementResponse());
        ConnectionPropertiesImpl connProps = new ConnectionPropertiesImpl(Boolean.valueOf(false), Boolean.valueOf(true), Integer.valueOf(Integer.MAX_VALUE), "catalog", "schema");
        responses.add((Service.Response)new Service.ConnectionSyncResponse((Meta.ConnectionProperties)connProps));
        responses.add((Service.Response)new Service.OpenConnectionResponse());
        responses.add((Service.Response)new Service.CloseConnectionResponse());
        responses.add((Service.Response)new Service.CreateStatementResponse("connectionId", Integer.MAX_VALUE));
        HashMap<Meta.DatabaseProperty, Object> propertyMap = new HashMap<Meta.DatabaseProperty, Object>();
        for (Meta.DatabaseProperty prop : Meta.DatabaseProperty.values()) {
            propertyMap.put(prop, prop.defaultValue);
        }
        responses.add((Service.Response)new Service.DatabasePropertyResponse(propertyMap));
        responses.add((Service.Response)new Service.ExecuteResponse(Arrays.asList(results1, results1, results1), false));
        responses.add((Service.Response)new Service.FetchResponse(frame, false, false));
        responses.add((Service.Response)new Service.FetchResponse(frame, true, true));
        responses.add((Service.Response)new Service.FetchResponse(frame, false, true));
        responses.add((Service.Response)new Service.PrepareResponse(new Meta.StatementHandle("connectionId", Integer.MAX_VALUE, signature)));
        StringWriter sw = new StringWriter();
        new Exception().printStackTrace(new PrintWriter(sw));
        responses.add((Service.Response)new Service.ErrorResponse(Collections.singletonList(sw.toString()), "Test Error Message", -1, "00000", AvaticaSeverity.WARNING));
        responses.add((Service.Response)new Service.SyncResultsResponse(false, false));
        responses.add((Service.Response)new Service.SyncResultsResponse(false, true));
        responses.add((Service.Response)new Service.SyncResultsResponse(true, false));
        return responses;
    }

    public ProtobufTranslationImplTest(T object, IdentityFunction<T> func) {
        this.object = object;
        this.function = func;
    }

    @Test
    public void testSerialization() throws Exception {
        Assert.assertEquals(this.object, this.function.apply(this.object));
    }

    private static class ResponseFunc
    implements IdentityFunction<Service.Response> {
        private final ProtobufTranslation translation;

        public ResponseFunc(ProtobufTranslation translation) {
            this.translation = translation;
        }

        @Override
        public Service.Response apply(Service.Response response) throws IOException {
            return this.translation.parseResponse(this.translation.serializeResponse(response));
        }
    }

    private static class RequestFunc
    implements IdentityFunction<Service.Request> {
        private final ProtobufTranslation translation;

        public RequestFunc(ProtobufTranslation translation) {
            this.translation = translation;
        }

        @Override
        public Service.Request apply(Service.Request request) throws IOException {
            return this.translation.parseRequest(this.translation.serializeRequest(request));
        }
    }

    private static interface IdentityFunction<A> {
        public A apply(A var1) throws IOException;
    }
}

