/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.proto.Requests;
import org.apache.calcite.avatica.proto.Responses;
import org.apache.calcite.avatica.remote.Handler;
import org.apache.calcite.avatica.remote.ProtobufHandler;
import org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.calcite.avatica.remote.Service;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ProtobufHandlerTest {
    private Service service;
    private ProtobufTranslation translation;
    private ProtobufHandler handler;

    @Before
    public void setupMocks() {
        this.service = (Service)Mockito.mock(Service.class);
        this.translation = (ProtobufTranslation)Mockito.mock(ProtobufTranslation.class);
        this.handler = new ProtobufHandler(this.service, this.translation);
    }

    @Test
    public void testFetch() throws Exception {
        String connectionId = "cnxn1";
        int statementId = 30;
        long offset = 10L;
        int fetchMaxRowCount = 100;
        ArrayList<Common.TypedValue> values = new ArrayList<Common.TypedValue>();
        values.add(Common.TypedValue.newBuilder().setType(Common.Rep.BOOLEAN).setBoolValue(true).build());
        values.add(Common.TypedValue.newBuilder().setType(Common.Rep.STRING).setStringValue("my_string").build());
        Requests.FetchRequest protoRequest = Requests.FetchRequest.newBuilder().setConnectionId("cnxn1").setStatementId(30).setOffset(10L).setFetchMaxRowCount(100).build();
        byte[] serializedRequest = protoRequest.toByteArray();
        Service.FetchRequest request = new Service.FetchRequest().deserialize((Message)protoRequest);
        ArrayList<Object[]> frameRows = new ArrayList<Object[]>();
        frameRows.add(new Object[]{true, "my_string"});
        Meta.Frame frame = Meta.Frame.create((int)0, (boolean)true, frameRows);
        Service.FetchResponse response = new Service.FetchResponse(frame, false, false);
        Mockito.when((Object)this.translation.parseRequest(serializedRequest)).thenReturn((Object)request);
        Mockito.when((Object)this.service.apply(request)).thenReturn((Object)response);
        Mockito.when((Object)this.translation.serializeResponse((Service.Response)response)).thenReturn((Object)response.serialize().toByteArray());
        Handler.HandlerResponse handlerResponse = this.handler.apply(serializedRequest);
        byte[] serializedResponse = (byte[])handlerResponse.getResponse();
        Assert.assertEquals((long)200L, (long)handlerResponse.getStatusCode());
        Responses.FetchResponse protoResponse = Responses.FetchResponse.parseFrom((byte[])serializedResponse);
        Common.Frame protoFrame = protoResponse.getFrame();
        Assert.assertEquals((long)frame.offset, (long)protoFrame.getOffset());
        Assert.assertEquals((Object)frame.done, (Object)protoFrame.getDone());
        List rows = protoFrame.getRowsList();
        Assert.assertEquals((long)1L, (long)rows.size());
        Common.Row row = (Common.Row)rows.get(0);
        List columnValues = row.getValueList();
        Assert.assertEquals((long)2L, (long)columnValues.size());
        Iterator iter = columnValues.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Common.ColumnValue column = (Common.ColumnValue)iter.next();
        Assert.assertEquals((long)1L, (long)column.getValueCount());
        Common.TypedValue value = column.getValue(0);
        Assert.assertEquals((Object)Common.Rep.BOOLEAN, (Object)value.getType());
        Assert.assertEquals((Object)true, (Object)value.getBoolValue());
        Assert.assertTrue((boolean)iter.hasNext());
        column = (Common.ColumnValue)iter.next();
        Assert.assertEquals((long)1L, (long)column.getValueCount());
        value = column.getValue(0);
        Assert.assertEquals((Object)Common.Rep.STRING, (Object)value.getType());
        Assert.assertEquals((Object)"my_string", (Object)value.getStringValue());
    }
}

