/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.avatica.AvaticaClientRuntimeException;
import org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.calcite.avatica.remote.Service;
import org.junit.Assert;
import org.junit.Test;

public class ErrorResponseTest {
    @Test
    public void testEquality() {
        String message = "There was an error";
        int code = 23;
        String state = "a1b2c";
        AvaticaSeverity severity = AvaticaSeverity.ERROR;
        List<String> exceptions = Arrays.asList("Server Stacktrace 1", "Server Stacktace 2");
        Assert.assertEquals((Object)new Service.ErrorResponse("There was an error", 23, "a1b2c", severity, exceptions), (Object)new Service.ErrorResponse("There was an error", 23, "a1b2c", severity, exceptions));
    }

    @Test
    public void testToClientRTE() {
        String message = "There was an error";
        int code = 23;
        String state = "a1b2c";
        AvaticaSeverity severity = AvaticaSeverity.ERROR;
        List<String> exceptions = Arrays.asList("Server Stacktrace 1", "Server Stacktace 2");
        Service.ErrorResponse resp = new Service.ErrorResponse("There was an error", 23, "a1b2c", severity, exceptions);
        AvaticaClientRuntimeException exception = resp.toException();
        Assert.assertTrue((String)("Expected error message to end with '" + resp.errorMessage + "', but was '" + exception.getMessage() + "'"), (boolean)exception.getMessage().endsWith(resp.errorMessage));
        Assert.assertEquals((long)resp.errorCode, (long)exception.getErrorCode());
        Assert.assertEquals((Object)resp.severity, (Object)exception.getSeverity());
        Assert.assertEquals((Object)resp.sqlState, (Object)exception.getSqlState());
        Assert.assertEquals((Object)resp.exceptions, (Object)exception.getServerExceptions());
    }
}

