/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.calcite.avatica.remote.AvaticaHttpClientImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AvaticaHttpClientTest {
    private static final String REQUEST = "{\"request\":\"createStatement\",\"connectionId\":\"8f3f28ee-d0bb-4cdb-a4b1-8f6e8476c534\"}";
    private static final String RESPONSE = "{\"response\":\"createStatement\",\"connectionId\":\"8f3f28ee-d0bb-4cdb-a4b1-8f6e8476c534\",\"statementId\":1608176856}";

    @Test
    public void testRetryOnUnavailable() throws Exception {
        URL url = new URL("http://127.0.0.1:8765");
        final HttpURLConnection cnxn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(RESPONSE.getBytes(StandardCharsets.UTF_8));
        AvaticaHttpClientImpl client = new AvaticaHttpClientImpl(url){

            HttpURLConnection openConnection() throws IOException {
                return cnxn;
            }
        };
        Mockito.when((Object)cnxn.getResponseCode()).thenReturn((Object)503, (Object[])new Integer[]{200});
        Mockito.when((Object)cnxn.getOutputStream()).thenReturn((Object)baos);
        Mockito.when((Object)cnxn.getInputStream()).thenReturn((Object)bais);
        byte[] response = client.send(REQUEST.getBytes(StandardCharsets.UTF_8));
        Assert.assertArrayEquals((byte[])RESPONSE.getBytes(StandardCharsets.UTF_8), (byte[])response);
    }

    @Test(expected=RuntimeException.class)
    public void testServerError() throws Exception {
        URL url = new URL("http://127.0.0.1:8765");
        final HttpURLConnection cnxn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AvaticaHttpClientImpl client = new AvaticaHttpClientImpl(url){

            HttpURLConnection openConnection() throws IOException {
                return cnxn;
            }
        };
        Mockito.when((Object)cnxn.getResponseCode()).thenReturn((Object)500);
        Mockito.when((Object)cnxn.getOutputStream()).thenReturn((Object)baos);
        client.send(REQUEST.getBytes(StandardCharsets.UTF_8));
    }
}

