/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.calcite.avatica.remote.AbstractHandler;
import org.apache.calcite.avatica.remote.AvaticaRuntimeException;
import org.apache.calcite.avatica.remote.Handler;
import org.apache.calcite.avatica.remote.Service;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractHandlerTest {
    private String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Objects.requireNonNull(e).printStackTrace(pw);
        return sw.toString();
    }

    @Test
    public void testExceptionUnwrappingWithoutContext() {
        AbstractHandler handler = (AbstractHandler)Mockito.mock(AbstractHandler.class);
        Mockito.when((Object)handler.unwrapException((Exception)Mockito.any(Exception.class))).thenCallRealMethod();
        RuntimeException e = new RuntimeException();
        Service.ErrorResponse resp = handler.unwrapException((Exception)e);
        Assert.assertTrue((String)("Response should be ErrorResponse, but was " + resp.getClass()), (boolean)(resp instanceof Service.ErrorResponse));
        Service.ErrorResponse errorResp = resp;
        Assert.assertEquals((long)-1L, (long)errorResp.errorCode);
        Assert.assertEquals((Object)AvaticaSeverity.UNKNOWN, (Object)errorResp.severity);
        Assert.assertEquals(Arrays.asList(this.exceptionToString(e)), (Object)errorResp.exceptions);
        e = new AvaticaRuntimeException();
        resp = handler.unwrapException((Exception)e);
        Assert.assertTrue((String)("Response should be ErrorResponse, but was " + resp.getClass()), (boolean)(resp instanceof Service.ErrorResponse));
        errorResp = resp;
        Assert.assertEquals((long)-1L, (long)errorResp.errorCode);
        Assert.assertEquals((Object)AvaticaSeverity.UNKNOWN, (Object)errorResp.severity);
        Assert.assertEquals(Arrays.asList(this.exceptionToString(e)), (Object)errorResp.exceptions);
    }

    @Test
    public void testExceptionUnwrappingWithContext() {
        AbstractHandler handler = (AbstractHandler)Mockito.mock(AbstractHandler.class);
        Mockito.when((Object)handler.unwrapException((Exception)Mockito.any(Exception.class))).thenCallRealMethod();
        String msg = "Something failed!";
        AvaticaRuntimeException e = new AvaticaRuntimeException("Something failed!", -1, "00000", AvaticaSeverity.FATAL);
        Service.ErrorResponse resp = handler.unwrapException((Exception)e);
        Assert.assertTrue((String)("Response should be ErrorResponse, but was " + resp.getClass()), (boolean)(resp instanceof Service.ErrorResponse));
        Service.ErrorResponse errorResp = resp;
        Assert.assertEquals((long)-1L, (long)errorResp.errorCode);
        Assert.assertEquals((Object)AvaticaSeverity.FATAL, (Object)errorResp.severity);
        Assert.assertEquals(Arrays.asList(this.exceptionToString((Exception)e)), (Object)errorResp.exceptions);
        Assert.assertEquals((Object)"Something failed!", (Object)errorResp.errorMessage);
    }

    @Test
    public void testFailedResponseSerialization() throws IOException {
        AbstractHandler handler = (AbstractHandler)Mockito.mock(AbstractHandler.class);
        Service.Request request = (Service.Request)Mockito.mock(Service.Request.class);
        Service.Response response = (Service.Response)Mockito.mock(Service.Response.class);
        IOException exception = new IOException();
        Service.ErrorResponse errorResponse = (Service.ErrorResponse)Mockito.mock(Service.ErrorResponse.class);
        String serializedErrorResponse = "An ErrorResponse";
        Mockito.when((Object)handler.apply((Object)Mockito.anyString())).thenCallRealMethod();
        Mockito.when((Object)handler.decode((Object)Mockito.anyString())).thenReturn((Object)request);
        Mockito.when((Object)request.accept((Service)Mockito.any(Service.class))).thenReturn((Object)response);
        Mockito.when((Object)handler.encode(response)).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)handler.unwrapException((Exception)exception)).thenReturn((Object)errorResponse);
        Mockito.when((Object)handler.encode((Service.Response)errorResponse)).thenReturn((Object)"An ErrorResponse");
        Handler.HandlerResponse handlerResp = handler.apply((Object)"this is mocked out");
        Assert.assertEquals((long)500L, (long)handlerResp.getStatusCode());
        Assert.assertEquals((Object)"An ErrorResponse", (Object)handlerResp.getResponse());
    }

    @Test
    public void testFailedErrorResponseSerialization() throws IOException {
        AbstractHandler handler = (AbstractHandler)Mockito.mock(AbstractHandler.class);
        Service.Request request = (Service.Request)Mockito.mock(Service.Request.class);
        Service.Response response = (Service.Response)Mockito.mock(Service.Response.class);
        IOException exception = new IOException();
        Service.ErrorResponse errorResponse = (Service.ErrorResponse)Mockito.mock(Service.ErrorResponse.class);
        Mockito.when((Object)handler.apply((Object)Mockito.anyString())).thenCallRealMethod();
        Mockito.when((Object)handler.decode((Object)Mockito.anyString())).thenReturn((Object)request);
        Mockito.when((Object)request.accept((Service)Mockito.any(Service.class))).thenReturn((Object)response);
        Mockito.when((Object)handler.encode(response)).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)handler.unwrapException((Exception)exception)).thenReturn((Object)errorResponse);
        Mockito.when((Object)handler.encode((Service.Response)errorResponse)).thenThrow(new Throwable[]{exception});
        try {
            handler.apply((Object)"this is mocked out");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)exception, (Object)e.getCause());
        }
    }

    @Test
    public void testFailedRequestDeserialization() throws IOException {
        AbstractHandler handler = (AbstractHandler)Mockito.mock(AbstractHandler.class);
        IOException exception = new IOException();
        Mockito.when((Object)handler.apply((Object)Mockito.anyString())).thenCallRealMethod();
        Mockito.when((Object)handler.decode((Object)Mockito.anyString())).thenThrow(new Throwable[]{exception});
        try {
            handler.apply((Object)"this is mocked out");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)exception, (Object)e.getCause());
        }
    }
}

