/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Statement;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.remote.MetaDataOperation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class QueryStateTest {
    private Connection conn;
    private DatabaseMetaData metadata;
    private Statement statement;

    @Before
    public void setup() throws Exception {
        this.conn = (Connection)Mockito.mock(Connection.class);
        this.metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        this.statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.conn.getMetaData()).thenReturn((Object)this.metadata);
    }

    @Test
    public void testMetadataGetAttributes() throws Exception {
        String catalog = "catalog";
        String schemaPattern = null;
        String typeNamePattern = "%";
        String attributeNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_ATTRIBUTES, new Object[]{"catalog", schemaPattern, "%", "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getAttributes("catalog", schemaPattern, "%", "%");
    }

    @Test
    public void testMetadataGetBestRowIdentifier() throws Exception {
        String catalog = "catalog";
        String schema = null;
        String table = "table";
        boolean scope = true;
        boolean nullable = true;
        QueryState state = new QueryState(MetaDataOperation.GET_BEST_ROW_IDENTIFIER, new Object[]{"catalog", schema, "table", 1, true});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getBestRowIdentifier("catalog", schema, "table", 1, true);
    }

    @Test
    public void testMetadataGetCatalogs() throws Exception {
        QueryState state = new QueryState(MetaDataOperation.GET_CATALOGS, new Object[0]);
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getCatalogs();
    }

    @Test
    public void testMetadataGetColumnPrivileges() throws Exception {
        String catalog = null;
        String schema = "schema";
        String table = "table";
        String columnNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_COLUMN_PRIVILEGES, new Object[]{catalog, "schema", "table", "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getColumnPrivileges(catalog, "schema", "table", "%");
    }

    @Test
    public void testMetadataGetColumns() throws Exception {
        String catalog = null;
        String schemaPattern = "%";
        String tableNamePattern = "%";
        String columnNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_COLUMNS, new Object[]{catalog, "%", "%", "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getColumns(catalog, "%", "%", "%");
    }

    @Test
    public void testMetadataGetCrossReference() throws Exception {
        String parentCatalog = null;
        String parentSchema = null;
        String parentTable = "%";
        String foreignCatalog = null;
        String foreignSchema = null;
        String foreignTable = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_CROSS_REFERENCE, new Object[]{parentCatalog, parentSchema, "%", foreignCatalog, foreignSchema, "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getCrossReference(parentCatalog, parentSchema, "%", foreignCatalog, foreignSchema, "%");
    }

    @Test
    public void testMetadataGetExportedKeys() throws Exception {
        String catalog = "";
        String schema = null;
        String table = "mytable";
        QueryState state = new QueryState(MetaDataOperation.GET_EXPORTED_KEYS, new Object[]{"", schema, "mytable"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getExportedKeys("", schema, "mytable");
    }

    @Test
    public void testMetadataGetFunctionColumns() throws Exception {
        String catalog = null;
        String schemaPattern = "%";
        String functionNamePattern = "%";
        String columnNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_FUNCTION_COLUMNS, new Object[]{catalog, "%", "%", "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getFunctionColumns(catalog, "%", "%", "%");
    }

    @Test
    public void testMetadataGetFunctions() throws Exception {
        String catalog = null;
        String schemaPattern = "%";
        String functionNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_FUNCTIONS, new Object[]{catalog, "%", "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getFunctions(catalog, "%", "%");
    }

    @Test
    public void testMetadataGetImportedKeys() throws Exception {
        String catalog = "";
        String schema = null;
        String table = "my_table";
        QueryState state = new QueryState(MetaDataOperation.GET_IMPORTED_KEYS, new Object[]{"", schema, "my_table"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getImportedKeys("", schema, "my_table");
    }

    @Test
    public void testMetadataGetIndexInfo() throws Exception {
        String catalog = "";
        String schema = null;
        String table = "my_table";
        boolean unique = true;
        boolean approximate = true;
        QueryState state = new QueryState(MetaDataOperation.GET_INDEX_INFO, new Object[]{"", schema, "my_table", true, true});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getIndexInfo("", schema, "my_table", true, true);
    }

    @Test
    public void testMetadataGetPrimaryKeys() throws Exception {
        String catalog = "";
        String schema = null;
        String table = "my_table";
        QueryState state = new QueryState(MetaDataOperation.GET_PRIMARY_KEYS, new Object[]{"", schema, "my_table"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getPrimaryKeys("", schema, "my_table");
    }

    @Test
    public void testMetadataGetProcedureColumns() throws Exception {
        String catalog = "";
        String schemaPattern = null;
        String procedureNamePattern = "%";
        String columnNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_PROCEDURE_COLUMNS, new Object[]{"", schemaPattern, "%", "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getProcedureColumns("", schemaPattern, "%", "%");
    }

    @Test
    public void testMetadataGetProcedures() throws Exception {
        String catalog = "";
        String schemaPattern = null;
        String procedureNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_PROCEDURES, new Object[]{"", schemaPattern, "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getProcedures("", schemaPattern, "%");
    }

    @Test
    public void testMetadataGetPseudoColumns() throws Exception {
        String catalog = "";
        String schemaPattern = null;
        String tableNamePattern = "%";
        String columnNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_PSEUDO_COLUMNS, new Object[]{"", schemaPattern, "%", "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getPseudoColumns("", schemaPattern, "%", "%");
    }

    @Test
    public void testMetadataGetSchemas() throws Exception {
        QueryState state = new QueryState(MetaDataOperation.GET_SCHEMAS, new Object[0]);
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getSchemas();
    }

    @Test
    public void testMetadataGetSchemasWithArgs() throws Exception {
        String catalog = "";
        String schemaPattern = null;
        QueryState state = new QueryState(MetaDataOperation.GET_SCHEMAS_WITH_ARGS, new Object[]{"", schemaPattern});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getSchemas("", schemaPattern);
    }

    @Test
    public void testMetadataGetSuperTables() throws Exception {
        String catalog = "";
        String schemaPattern = null;
        String tableNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_SUPER_TABLES, new Object[]{"", schemaPattern, "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getSuperTables("", schemaPattern, "%");
    }

    @Test
    public void testMetadataGetSuperTypes() throws Exception {
        String catalog = "";
        String schemaPattern = null;
        String tableNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_SUPER_TYPES, new Object[]{"", schemaPattern, "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getSuperTypes("", schemaPattern, "%");
    }

    @Test
    public void testMetadataGetTablePrivileges() throws Exception {
        String catalog = "";
        String schemaPattern = null;
        String tableNamePattern = "%";
        QueryState state = new QueryState(MetaDataOperation.GET_TABLE_PRIVILEGES, new Object[]{"", schemaPattern, "%"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getTablePrivileges("", schemaPattern, "%");
    }

    @Test
    public void testMetadataGetTables() throws Exception {
        String catalog = "";
        String schemaPattern = null;
        String tableNamePattern = "%";
        String[] types = new String[]{"VIEW", "TABLE"};
        QueryState state = new QueryState(MetaDataOperation.GET_TABLES, new Object[]{"", schemaPattern, "%", types});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getTables("", schemaPattern, "%", types);
    }

    @Test
    public void testMetadataGetTableTypes() throws Exception {
        QueryState state = new QueryState(MetaDataOperation.GET_TABLE_TYPES, new Object[0]);
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getTableTypes();
    }

    @Test
    public void testMetadataGetTypeInfo() throws Exception {
        QueryState state = new QueryState(MetaDataOperation.GET_TYPE_INFO, new Object[0]);
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getTypeInfo();
    }

    @Test
    public void testMetadataGetUDTs() throws Exception {
        String catalog = "";
        String schemaPattern = null;
        String typeNamePattern = "%";
        int[] types = new int[]{1, 2};
        QueryState state = new QueryState(MetaDataOperation.GET_UDTS, new Object[]{"", schemaPattern, "%", types});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getUDTs("", schemaPattern, "%", types);
    }

    @Test
    public void testMetadataGetVersionColumns() throws Exception {
        String catalog = "";
        String schemaPattern = null;
        String table = "my_table";
        QueryState state = new QueryState(MetaDataOperation.GET_VERSION_COLUMNS, new Object[]{"", schemaPattern, "my_table"});
        state.invoke(this.conn, this.statement);
        ((DatabaseMetaData)Mockito.verify((Object)this.metadata)).getVersionColumns("", schemaPattern, "my_table");
    }

    @Test
    public void testSerialization() throws Exception {
        String catalog = "catalog";
        Object schema = null;
        String table = "table";
        boolean scope = true;
        boolean nullable = true;
        QueryState state = new QueryState(MetaDataOperation.GET_BEST_ROW_IDENTIFIER, new Object[]{"catalog", schema, "table", 1, true});
        Assert.assertEquals((Object)state, (Object)QueryState.fromProto((Common.QueryState)state.toProto()));
        Object schemaPattern = null;
        String typeNamePattern = "%";
        int[] types = new int[]{1, 2};
        state = new QueryState(MetaDataOperation.GET_UDTS, new Object[]{"catalog", schemaPattern, "%", types});
        Assert.assertEquals((Object)state, (Object)QueryState.fromProto((Common.QueryState)state.toProto()));
        state = new QueryState("SELECT * FROM foo");
        Assert.assertEquals((Object)state, (Object)QueryState.fromProto((Common.QueryState)state.toProto()));
    }
}

