/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.proto.Common;
import org.junit.Assert;
import org.junit.Test;

public class FrameTest {
    private void serializeAndTestEquality(Meta.Frame frame) {
        Meta.Frame frameCopy = Meta.Frame.fromProto((Common.Frame)frame.toProto());
        Assert.assertEquals((Object)frame.done, (Object)frameCopy.done);
        Assert.assertEquals((long)frame.offset, (long)frameCopy.offset);
        Iterable origRows = frame.rows;
        Iterable copiedRows = frameCopy.rows;
        Assert.assertEquals((String)"Expected rows to both be null, or both be non-null", (Object)(origRows == null ? 1 : 0), (Object)(copiedRows == null ? 1 : 0));
        Iterator origIter = origRows.iterator();
        Iterator copiedIter = copiedRows.iterator();
        while (origIter.hasNext() && copiedIter.hasNext()) {
            Object orig = origIter.next();
            Object copy = copiedIter.next();
            Assert.assertEquals((Object)(orig == null ? 1 : 0), (Object)(copy == null ? 1 : 0));
            Assert.assertEquals(Object[].class, orig.getClass());
            Assert.assertTrue((String)("Expected List but got " + copy.getClass()), (boolean)(copy instanceof List));
            List copyList = (List)copy;
            Assert.assertArrayEquals((Object[])((Object[])orig), (Object[])copyList.toArray(new Object[0]));
        }
        Assert.assertEquals((Object)origIter.hasNext(), (Object)copiedIter.hasNext());
    }

    @Test
    public void testEmpty() {
        this.serializeAndTestEquality(Meta.Frame.EMPTY);
    }

    @Test
    public void testSingleRow() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        rows.add(new Object[]{"string", Integer.MAX_VALUE, new Date().getTime()});
        Meta.Frame singleRow = new Meta.Frame(0L, true, rows);
        this.serializeAndTestEquality(singleRow);
    }

    @Test
    public void testMultipleRows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        rows.add(new Object[]{"string", Integer.MAX_VALUE, new Date().getTime()});
        rows.add(new Object[]{"gnirts", 0, Long.MIN_VALUE});
        rows.add(new Object[]{"", null, Long.MAX_VALUE});
        Meta.Frame singleRow = new Meta.Frame(0L, true, rows);
        this.serializeAndTestEquality(singleRow);
    }
}

