/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.avatica.remote.JsonHandler;
import org.apache.calcite.avatica.remote.LocalJsonService;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.remote.TypedValue;
import org.junit.Assert;
import org.junit.Test;

public class JsonHandlerTest {
    @Test
    public void testFetchRequestWithNumberParameter() {
        ArrayList<TypedValue> expectedParameterValues = new ArrayList<TypedValue>();
        ParameterValuesCheckingService service = new ParameterValuesCheckingService(expectedParameterValues);
        LocalJsonService jsonService = new LocalJsonService((Service)service);
        JsonHandler jsonHandler = new JsonHandler((Service)jsonService);
        expectedParameterValues.add(TypedValue.create((String)"NUMBER", (Object)new BigDecimal("333.333")));
        jsonHandler.apply("{'request':'fetch','parameterValues':[{'type':'NUMBER','value':333.333}]}");
        Assert.assertTrue((boolean)expectedParameterValues.isEmpty());
        expectedParameterValues.add(TypedValue.create((String)"NUMBER", (Object)new BigDecimal("333")));
        jsonHandler.apply("{'request':'fetch','parameterValues':[{'type':'NUMBER','value':333}]}");
        Assert.assertTrue((boolean)expectedParameterValues.isEmpty());
    }

    public static class ParameterValuesCheckingService
    extends NoopService {
        final List<TypedValue> expectedParameterValues;

        public ParameterValuesCheckingService(List<TypedValue> epv) {
            this.expectedParameterValues = epv;
        }

        @Override
        public Service.FetchResponse apply(Service.FetchRequest request) {
            Assert.assertEquals((long)this.expectedParameterValues.size(), (long)request.parameterValues.size());
            for (int i = 0; i < this.expectedParameterValues.size(); ++i) {
                Assert.assertEquals((Object)this.expectedParameterValues.get((int)i).type, (Object)((TypedValue)request.parameterValues.get((int)i)).type);
                Assert.assertEquals((Object)this.expectedParameterValues.get((int)i).value, (Object)((TypedValue)request.parameterValues.get((int)i)).value);
            }
            this.expectedParameterValues.clear();
            return null;
        }
    }

    public static class NoopService
    implements Service {
        public Service.ResultSetResponse apply(Service.CatalogsRequest request) {
            return null;
        }

        public Service.ResultSetResponse apply(Service.SchemasRequest request) {
            return null;
        }

        public Service.ResultSetResponse apply(Service.TablesRequest request) {
            return null;
        }

        public Service.ResultSetResponse apply(Service.TableTypesRequest request) {
            return null;
        }

        public Service.ResultSetResponse apply(Service.TypeInfoRequest request) {
            return null;
        }

        public Service.ResultSetResponse apply(Service.ColumnsRequest request) {
            return null;
        }

        public Service.PrepareResponse apply(Service.PrepareRequest request) {
            return null;
        }

        public Service.ExecuteResponse apply(Service.PrepareAndExecuteRequest request) {
            return null;
        }

        public Service.FetchResponse apply(Service.FetchRequest request) {
            return null;
        }

        public Service.CreateStatementResponse apply(Service.CreateStatementRequest request) {
            return null;
        }

        public Service.CloseStatementResponse apply(Service.CloseStatementRequest request) {
            return null;
        }

        public Service.CloseConnectionResponse apply(Service.CloseConnectionRequest request) {
            return null;
        }

        public Service.ConnectionSyncResponse apply(Service.ConnectionSyncRequest request) {
            return null;
        }

        public Service.DatabasePropertyResponse apply(Service.DatabasePropertyRequest request) {
            return null;
        }
    }
}

