/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class HttpServer {
    private static final Log LOG = LogFactory.getLog(HttpServer.class);
    private Server server;
    private int port = -1;
    private final Handler handler;

    public HttpServer(int port, Handler handler) {
        this.port = port;
        this.handler = handler;
    }

    public void start() {
        if (this.server != null) {
            throw new RuntimeException("Server is already started");
        }
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setDaemon(true);
        this.server = new Server((ThreadPool)threadPool);
        this.server.manage((Object)threadPool);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setIdleTimeout(60000L);
        connector.setSoLingerTime(-1);
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{this.handler, new DefaultHandler()});
        this.server.setHandler((Handler)handlerList);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.port = connector.getLocalPort();
        LOG.info((Object)("Service listening on port " + this.getPort() + "."));
    }

    public void stop() {
        if (this.server == null) {
            throw new RuntimeException("Server is already stopped");
        }
        LOG.info((Object)"Service terminating.");
        try {
            Server server1 = this.server;
            this.port = -1;
            this.server = null;
            server1.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public int getPort() {
        return this.port;
    }
}

