/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.jdbc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.avatica.jdbc.JdbcResultSet;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcMeta
implements Meta {
    private static final Log LOG = LogFactory.getLog(JdbcMeta.class);
    private static final String CONN_CACHE_KEY_BASE = "avatica.connectioncache";
    final Calendar calendar = Calendar.getInstance();
    private static final String STMT_CACHE_KEY_BASE = "avatica.statementcache";
    private static final String DEFAULT_CONN_ID = UUID.fromString("00000000-0000-0000-0000-000000000000").toString();
    private final String url;
    private final Properties info;
    private final Connection connection;
    private final Cache<String, Connection> connectionCache;
    private final Cache<Integer, StatementInfo> statementCache;

    protected static List<ColumnMetaData> columns(ResultSetMetaData metaData) throws SQLException {
        if (metaData == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            SqlType sqlType = SqlType.valueOf((int)metaData.getColumnType(i));
            ColumnMetaData.Rep rep = ColumnMetaData.Rep.of((Type)sqlType.internal);
            ColumnMetaData.ScalarType t = ColumnMetaData.scalar((int)metaData.getColumnType(i), (String)metaData.getColumnTypeName(i), (ColumnMetaData.Rep)rep);
            ColumnMetaData md = new ColumnMetaData(i - 1, metaData.isAutoIncrement(i), metaData.isCaseSensitive(i), metaData.isSearchable(i), metaData.isCurrency(i), metaData.isNullable(i), metaData.isSigned(i), metaData.getColumnDisplaySize(i), metaData.getColumnLabel(i), metaData.getColumnName(i), metaData.getSchemaName(i), metaData.getPrecision(i), metaData.getScale(i), metaData.getTableName(i), metaData.getCatalogName(i), (ColumnMetaData.AvaticaType)t, metaData.isReadOnly(i), metaData.isWritable(i), metaData.isDefinitelyWritable(i), metaData.getColumnClassName(i));
            columns.add(md);
        }
        return columns;
    }

    protected static List<AvaticaParameter> parameters(ParameterMetaData metaData) throws SQLException {
        if (metaData == null) {
            return Collections.emptyList();
        }
        ArrayList<AvaticaParameter> params = new ArrayList<AvaticaParameter>();
        for (int i = 1; i <= metaData.getParameterCount(); ++i) {
            params.add(new AvaticaParameter(metaData.isSigned(i), metaData.getPrecision(i), metaData.getScale(i), metaData.getParameterType(i), metaData.getParameterTypeName(i), metaData.getParameterClassName(i), "?" + i));
        }
        return params;
    }

    protected static Meta.Signature signature(ResultSetMetaData metaData, ParameterMetaData parameterMetaData, String sql) throws SQLException {
        return new Meta.Signature(JdbcMeta.columns(metaData), sql, JdbcMeta.parameters(parameterMetaData), null, Meta.CursorFactory.LIST);
    }

    protected static Meta.Signature signature(ResultSetMetaData metaData) throws SQLException {
        return JdbcMeta.signature(metaData, null, null);
    }

    public JdbcMeta(String url) throws SQLException {
        this(url, new Properties());
    }

    public JdbcMeta(String url, final String user, final String password) throws SQLException {
        this(url, new Properties(){
            {
                this.put("user", user);
                this.put("password", password);
            }
        });
    }

    public JdbcMeta(String url, Properties info) throws SQLException {
        this.url = url;
        this.info = info;
        this.connection = DriverManager.getConnection(url, info);
        int concurrencyLevel = Integer.parseInt(info.getProperty(ConnectionCacheSettings.CONCURRENCY_LEVEL.key(), ConnectionCacheSettings.CONCURRENCY_LEVEL.defaultValue()));
        int initialCapacity = Integer.parseInt(info.getProperty(ConnectionCacheSettings.INITIAL_CAPACITY.key(), ConnectionCacheSettings.INITIAL_CAPACITY.defaultValue()));
        long maxCapacity = Long.parseLong(info.getProperty(ConnectionCacheSettings.MAX_CAPACITY.key(), ConnectionCacheSettings.MAX_CAPACITY.defaultValue()));
        long connectionExpiryDuration = Long.parseLong(info.getProperty(ConnectionCacheSettings.EXPIRY_DURATION.key(), ConnectionCacheSettings.EXPIRY_DURATION.defaultValue()));
        TimeUnit connectionExpiryUnit = TimeUnit.valueOf(info.getProperty(ConnectionCacheSettings.EXPIRY_UNIT.key(), ConnectionCacheSettings.EXPIRY_UNIT.defaultValue()));
        this.connectionCache = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumSize(maxCapacity).expireAfterAccess(connectionExpiryDuration, connectionExpiryUnit).removalListener((RemovalListener)new ConnectionExpiryHandler()).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("instantiated connection cache: " + this.connectionCache.stats()));
        }
        concurrencyLevel = Integer.parseInt(info.getProperty(StatementCacheSettings.CONCURRENCY_LEVEL.key(), StatementCacheSettings.CONCURRENCY_LEVEL.defaultValue()));
        initialCapacity = Integer.parseInt(info.getProperty(StatementCacheSettings.INITIAL_CAPACITY.key(), StatementCacheSettings.INITIAL_CAPACITY.defaultValue()));
        maxCapacity = Long.parseLong(info.getProperty(StatementCacheSettings.MAX_CAPACITY.key(), StatementCacheSettings.MAX_CAPACITY.defaultValue()));
        connectionExpiryDuration = Long.parseLong(info.getProperty(StatementCacheSettings.EXPIRY_DURATION.key(), StatementCacheSettings.EXPIRY_DURATION.defaultValue()));
        connectionExpiryUnit = TimeUnit.valueOf(info.getProperty(StatementCacheSettings.EXPIRY_UNIT.key(), StatementCacheSettings.EXPIRY_UNIT.defaultValue()));
        this.statementCache = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumSize(maxCapacity).expireAfterAccess(connectionExpiryDuration, connectionExpiryUnit).removalListener((RemovalListener)new StatementExpiryHandler()).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("instantiated statement cache: " + this.statementCache.stats()));
        }
    }

    public Map<Meta.DatabaseProperty, Object> getDatabaseProperties() {
        try {
            HashMap<Meta.DatabaseProperty, Object> map = new HashMap<Meta.DatabaseProperty, Object>();
            DatabaseMetaData metaData = this.connection.getMetaData();
            for (Meta.DatabaseProperty p : Meta.DatabaseProperty.values()) {
                JdbcMeta.addProperty(map, metaData, p);
            }
            return map;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object addProperty(Map<Meta.DatabaseProperty, Object> map, DatabaseMetaData metaData, Meta.DatabaseProperty p) throws SQLException {
        try {
            return map.put(p, p.method.invoke((Object)metaData, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        try {
            String[] types = new String[typeList == null ? 0 : typeList.size()];
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getTables(catalog, schemaPattern.s, tableNamePattern.s, typeList == null ? types : typeList.toArray(types)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getColumns(catalog, schemaPattern.s, tableNamePattern.s, columnNamePattern.s));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getSchemas(String catalog, Meta.Pat schemaPattern) {
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getSchemas(catalog, schemaPattern.s));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getCatalogs() {
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getCatalogs());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getTableTypes() {
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getTableTypes());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getProcedures(String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern) {
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getProcedures(catalog, schemaPattern.s, procedureNamePattern.s));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getProcedureColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern, Meta.Pat columnNamePattern) {
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getProcedureColumns(catalog, schemaPattern.s, procedureNamePattern.s, columnNamePattern.s));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getColumnPrivileges(String catalog, String schema, String table, Meta.Pat columnNamePattern) {
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getColumnPrivileges(catalog, schema, table, columnNamePattern.s));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getTablePrivileges(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getTablePrivileges(catalog, schemaPattern.s, tableNamePattern.s));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("getBestRowIdentifier catalog:" + catalog + " schema:" + schema + " table:" + table + " scope:" + scope + " nullable:" + nullable));
        }
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getBestRowIdentifier(catalog, schema, table, scope, nullable));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getVersionColumns(String catalog, String schema, String table) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("getVersionColumns catalog:" + catalog + " schema:" + schema + " table:" + table));
        }
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getVersionColumns(catalog, schema, table));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getPrimaryKeys(String catalog, String schema, String table) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("getPrimaryKeys catalog:" + catalog + " schema:" + schema + " table:" + table));
        }
        try {
            return JdbcResultSet.create(DEFAULT_CONN_ID, -1, this.connection.getMetaData().getPrimaryKeys(catalog, schema, table));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.MetaResultSet getImportedKeys(String catalog, String schema, String table) {
        return null;
    }

    public Meta.MetaResultSet getExportedKeys(String catalog, String schema, String table) {
        return null;
    }

    public Meta.MetaResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return null;
    }

    public Meta.MetaResultSet getTypeInfo() {
        return null;
    }

    public Meta.MetaResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        return null;
    }

    public Meta.MetaResultSet getUDTs(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, int[] types) {
        return null;
    }

    public Meta.MetaResultSet getSuperTypes(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern) {
        return null;
    }

    public Meta.MetaResultSet getSuperTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return null;
    }

    public Meta.MetaResultSet getAttributes(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, Meta.Pat attributeNamePattern) {
        return null;
    }

    public Meta.MetaResultSet getClientInfoProperties() {
        return null;
    }

    public Meta.MetaResultSet getFunctions(String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern) {
        return null;
    }

    public Meta.MetaResultSet getFunctionColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern, Meta.Pat columnNamePattern) {
        return null;
    }

    public Meta.MetaResultSet getPseudoColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        return null;
    }

    public Iterable<Object> createIterable(Meta.StatementHandle handle, Meta.Signature signature, List<TypedValue> parameterValues, Meta.Frame firstFrame) {
        return null;
    }

    protected Connection getConnection(String id) throws SQLException {
        Connection conn = (Connection)this.connectionCache.getIfPresent((Object)id);
        if (conn == null) {
            conn = DriverManager.getConnection(this.url, this.info);
            this.connectionCache.put((Object)id, (Object)conn);
        }
        return conn;
    }

    public Meta.StatementHandle createStatement(Meta.ConnectionHandle ch) {
        try {
            Connection conn = this.getConnection(ch.id);
            Statement statement = conn.createStatement();
            int id = System.identityHashCode(statement);
            this.statementCache.put((Object)id, (Object)new StatementInfo(statement));
            Meta.StatementHandle h = new Meta.StatementHandle(ch.id, id, null);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("created statement " + h));
            }
            return h;
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public void closeStatement(Meta.StatementHandle h) {
        StatementInfo info = (StatementInfo)this.statementCache.getIfPresent((Object)h.id);
        if (info == null || info.statement == null) {
            LOG.debug((Object)("client requested close unknown statement " + h));
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("closing statement " + h));
        }
        try {
            if (info.resultSet != null) {
                info.resultSet.close();
            }
            info.statement.close();
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
        finally {
            this.statementCache.invalidate((Object)h.id);
        }
    }

    public void closeConnection(Meta.ConnectionHandle ch) {
        Connection conn = (Connection)this.connectionCache.getIfPresent((Object)ch.id);
        if (conn == null) {
            LOG.debug((Object)("client requested close unknown connection " + ch));
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("closing connection " + ch));
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
        finally {
            this.connectionCache.invalidate((Object)ch.id);
        }
    }

    protected void apply(Connection conn, Meta.ConnectionProperties connProps) throws SQLException {
        if (connProps.isAutoCommit() != null) {
            conn.setAutoCommit(connProps.isAutoCommit());
        }
        if (connProps.isReadOnly() != null) {
            conn.setReadOnly(connProps.isReadOnly());
        }
        if (connProps.getTransactionIsolation() != null) {
            conn.setTransactionIsolation(connProps.getTransactionIsolation());
        }
        if (connProps.getCatalog() != null) {
            conn.setCatalog(connProps.getCatalog());
        }
        if (connProps.getSchema() != null) {
            conn.setSchema(connProps.getSchema());
        }
    }

    public Meta.ConnectionProperties connectionSync(Meta.ConnectionHandle ch, Meta.ConnectionProperties connProps) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("syncing properties for connection " + ch));
        }
        try {
            Connection conn = this.getConnection(ch.id);
            ConnectionPropertiesImpl props = new ConnectionPropertiesImpl(conn).merge(connProps);
            if (props.isDirty()) {
                this.apply(conn, (Meta.ConnectionProperties)props);
                props.setDirty(false);
            }
            return props;
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    private RuntimeException propagate(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    public Meta.StatementHandle prepare(Meta.ConnectionHandle ch, String sql, int maxRowCount) {
        try {
            Connection conn = this.getConnection(ch.id);
            PreparedStatement statement = conn.prepareStatement(sql);
            int id = System.identityHashCode(statement);
            this.statementCache.put((Object)id, (Object)new StatementInfo(statement));
            Meta.StatementHandle h = new Meta.StatementHandle(ch.id, id, JdbcMeta.signature(statement.getMetaData(), statement.getParameterMetaData(), sql));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("prepared statement " + h));
            }
            return h;
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public Meta.ExecuteResult prepareAndExecute(Meta.ConnectionHandle ch, String sql, int maxRowCount, Meta.PrepareCallback callback) {
        try {
            Connection connection = this.getConnection(ch.id);
            PreparedStatement statement = connection.prepareStatement(sql);
            int id = System.identityHashCode(statement);
            StatementInfo info = new StatementInfo(statement);
            this.statementCache.put((Object)id, (Object)info);
            boolean ret = statement.execute();
            info.resultSet = statement.getResultSet();
            assert (ret || info.resultSet == null);
            ArrayList<Meta.MetaResultSet> resultSets = new ArrayList<Meta.MetaResultSet>();
            if (info.resultSet == null) {
                resultSets.add(Meta.MetaResultSet.count((String)ch.id, (int)id, (int)statement.getUpdateCount()));
            } else {
                resultSets.add(JdbcResultSet.create(ch.id, id, info.resultSet));
            }
            if (LOG.isTraceEnabled()) {
                Meta.StatementHandle h = new Meta.StatementHandle(ch.id, id, null);
                LOG.trace((Object)("prepAndExec statement " + h));
            }
            return new Meta.ExecuteResult(resultSets);
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    public Meta.Frame fetch(Meta.StatementHandle h, List<TypedValue> parameterValues, int offset, int fetchMaxRowCount) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("fetching " + h + " offset:" + offset + " fetchMaxRowCount:" + fetchMaxRowCount));
        }
        try {
            StatementInfo statementInfo = (StatementInfo)Objects.requireNonNull(this.statementCache.getIfPresent((Object)h.id), "Statement not found, potentially expired. " + h);
            if (statementInfo.resultSet == null || parameterValues != null) {
                if (statementInfo.resultSet != null) {
                    statementInfo.resultSet.close();
                }
                PreparedStatement preparedStatement = (PreparedStatement)statementInfo.statement;
                if (parameterValues != null) {
                    for (int i = 0; i < parameterValues.size(); ++i) {
                        TypedValue o = parameterValues.get(i);
                        preparedStatement.setObject(i + 1, o.toJdbc(this.calendar));
                    }
                }
                if (preparedStatement.execute()) {
                    statementInfo.resultSet = preparedStatement.getResultSet();
                }
            }
            if (statementInfo.resultSet == null) {
                return Meta.Frame.EMPTY;
            }
            return JdbcResultSet.frame(statementInfo.resultSet, offset, fetchMaxRowCount, this.calendar);
        }
        catch (SQLException e) {
            throw this.propagate(e);
        }
    }

    private static class StatementInfo {
        final Statement statement;
        ResultSet resultSet;

        private StatementInfo(Statement statement) {
            this.statement = Objects.requireNonNull(statement);
        }
    }

    private class StatementExpiryHandler
    implements RemovalListener<Integer, StatementInfo> {
        private StatementExpiryHandler() {
        }

        public void onRemoval(RemovalNotification<Integer, StatementInfo> notification) {
            Integer stmtId = (Integer)notification.getKey();
            StatementInfo doomed = (StatementInfo)notification.getValue();
            if (doomed == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Expiring statement " + stmtId + " because " + notification.getCause()));
            }
            try {
                if (doomed.resultSet != null) {
                    doomed.resultSet.close();
                }
                if (doomed.statement != null) {
                    doomed.statement.close();
                }
            }
            catch (Throwable t) {
                LOG.info((Object)("Exception thrown while expiring statement " + stmtId));
            }
        }
    }

    private class ConnectionExpiryHandler
    implements RemovalListener<String, Connection> {
        private ConnectionExpiryHandler() {
        }

        public void onRemoval(RemovalNotification<String, Connection> notification) {
            String connectionId = (String)notification.getKey();
            Connection doomed = (Connection)notification.getValue();
            if (notification.getValue() == JdbcMeta.this.connection) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Expiring connection " + connectionId + " because " + notification.getCause()));
            }
            try {
                if (doomed != null) {
                    doomed.close();
                }
            }
            catch (Throwable t) {
                LOG.info((Object)("Exception thrown while expiring connection " + connectionId), t);
            }
        }
    }

    public static enum StatementCacheSettings {
        CONCURRENCY_LEVEL("avatica.statementcache.concurrency", "100"),
        INITIAL_CAPACITY("avatica.statementcache.initialcapacity", "1000"),
        MAX_CAPACITY("avatica.statementcache.maxcapacity", "10000"),
        EXPIRY_DURATION("avatica.statementcache.expirydiration", "5"),
        EXPIRY_UNIT("avatica.statementcache.expiryunit", TimeUnit.MINUTES.name());

        private final String key;
        private final String defaultValue;

        private StatementCacheSettings(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String key() {
            return this.key;
        }

        public String defaultValue() {
            return this.defaultValue;
        }
    }

    public static enum ConnectionCacheSettings {
        CONCURRENCY_LEVEL("avatica.connectioncache.concurrency", "10"),
        INITIAL_CAPACITY("avatica.connectioncache.initialcapacity", "100"),
        MAX_CAPACITY("avatica.connectioncache.maxcapacity", "1000"),
        EXPIRY_DURATION("avatica.connectioncache.expiryduration", "10"),
        EXPIRY_UNIT("avatica.connectioncache.expiryunit", TimeUnit.MINUTES.name());

        private final String key;
        private final String defaultValue;

        private ConnectionCacheSettings(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String key() {
            return this.key;
        }

        public String defaultValue() {
            return this.defaultValue;
        }
    }
}

