/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.jdbc;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.jdbc.JdbcMeta;

class JdbcResultSet
extends Meta.MetaResultSet {
    protected JdbcResultSet(String connectionId, int statementId, boolean ownStatement, Meta.Signature signature, Meta.Frame firstFrame) {
        super(connectionId, statementId, ownStatement, signature, firstFrame, -1);
    }

    public static JdbcResultSet create(String connectionId, int statementId, ResultSet resultSet) {
        try {
            Meta.Signature sig = JdbcMeta.signature(resultSet.getMetaData());
            Meta.Frame firstFrame = JdbcResultSet.frame(resultSet, 0, -1);
            resultSet.close();
            return new JdbcResultSet(connectionId, statementId, true, sig, firstFrame);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static Meta.Frame frame(ResultSet resultSet, int offset, int fetchMaxRowCount) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        int[] types = new int[columnCount];
        for (int i = 0; i < types.length; ++i) {
            types[i] = metaData.getColumnType(i + 1);
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        boolean done = false;
        for (int i = 0; fetchMaxRowCount < 0 || i < fetchMaxRowCount; ++i) {
            if (!resultSet.next()) {
                done = true;
                break;
            }
            Object[] columns = new Object[columnCount];
            for (int j = 0; j < columnCount; ++j) {
                columns[j] = JdbcResultSet.getValue(resultSet, types[j], j);
            }
            rows.add(columns);
        }
        return new Meta.Frame(offset, done, rows);
    }

    private static Object getValue(ResultSet resultSet, int type, int j) throws SQLException {
        switch (type) {
            case -5: {
                long aLong = resultSet.getLong(j + 1);
                return aLong == 0L && resultSet.wasNull() ? null : Long.valueOf(aLong);
            }
            case 4: {
                int anInt = resultSet.getInt(j + 1);
                return anInt == 0 && resultSet.wasNull() ? null : Integer.valueOf(anInt);
            }
            case 5: {
                short aShort = resultSet.getShort(j + 1);
                return aShort == 0 && resultSet.wasNull() ? null : Short.valueOf(aShort);
            }
            case -6: {
                byte aByte = resultSet.getByte(j + 1);
                return aByte == 0 && resultSet.wasNull() ? null : Byte.valueOf(aByte);
            }
            case 6: 
            case 8: {
                double aDouble = resultSet.getDouble(j + 1);
                return aDouble == 0.0 && resultSet.wasNull() ? null : Double.valueOf(aDouble);
            }
            case 7: {
                float aFloat = resultSet.getFloat(j + 1);
                return (double)aFloat == 0.0 && resultSet.wasNull() ? null : Float.valueOf(aFloat);
            }
            case 91: {
                Date aDate = resultSet.getDate(j + 1);
                return aDate == null ? null : Integer.valueOf((int)(aDate.getTime() / 86400000L));
            }
            case 92: {
                Time aTime = resultSet.getTime(j + 1);
                return aTime == null ? null : Integer.valueOf((int)(aTime.getTime() % 86400000L));
            }
            case 93: {
                Timestamp aTimestamp = resultSet.getTimestamp(j + 1);
                return aTimestamp == null ? null : Long.valueOf(aTimestamp.getTime());
            }
        }
        return resultSet.getObject(j + 1);
    }
}

