/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.tck.tests;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.calcite.avatica.tck.tests.BaseTckTest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class InsertTest
extends BaseTckTest {
    @Test
    public void simpleInsert() throws Exception {
        String tableName = this.getTableName();
        try (Statement stmt = this.connection.createStatement();){
            Assert.assertFalse((boolean)stmt.execute("DROP TABLE IF EXISTS " + tableName));
            String sql = "CREATE TABLE " + tableName + " (pk integer not null primary key, col1 varchar(10))";
            Assert.assertFalse((boolean)stmt.execute(sql));
            for (int i = 0; i < 10; ++i) {
                sql = "INSERT INTO " + tableName + " values (" + i + ", '" + i + "')";
                Assert.assertEquals((long)1L, (long)stmt.executeUpdate(sql));
            }
            ResultSet results = stmt.executeQuery("SELECT * FROM " + tableName);
            Assert.assertNotNull((Object)results);
            for (int i = 0; i < 10; ++i) {
                Assert.assertTrue((boolean)results.next());
                Assert.assertEquals((long)i, (long)results.getInt(1));
                Assert.assertEquals((Object)Integer.toString(i), (Object)results.getString(1));
            }
            Assert.assertFalse((boolean)results.next());
            results.close();
        }
    }

    @Test
    public void preparedStatementInsert() throws Exception {
        String tableName = this.getTableName();
        String insertSql = "INSERT INTO " + tableName + " values(?, ?)";
        try (Statement stmt = this.connection.createStatement();){
            Assert.assertFalse((boolean)stmt.execute("DROP TABLE IF EXISTS " + tableName));
            String sql = "CREATE TABLE " + tableName + " (pk integer not null primary key, col1 varchar(10))";
            Assert.assertFalse((boolean)stmt.execute(sql));
            try (PreparedStatement pstmt = this.connection.prepareStatement(insertSql);){
                for (int i = 0; i < 10; ++i) {
                    pstmt.setInt(1, i);
                    pstmt.setString(2, "a_" + Integer.toString(i));
                    Assert.assertEquals((long)1L, (long)pstmt.executeUpdate());
                }
            }
            ResultSet results = stmt.executeQuery("SELECT COUNT(pk) from " + tableName);
            Assert.assertNotNull((Object)results);
            Assert.assertTrue((boolean)results.next());
            Assert.assertEquals((long)10L, (long)results.getInt(1));
            results = stmt.executeQuery("SELECT * from " + tableName);
            Assert.assertNotNull((Object)results);
            for (int i = 0; i < 10; ++i) {
                Assert.assertTrue((boolean)results.next());
                Assert.assertEquals((long)i, (long)results.getInt(1));
                Assert.assertEquals((Object)("a_" + i), (Object)results.getString(2));
            }
            Assert.assertFalse((boolean)results.next());
            results.close();
        }
    }

    @Test
    public void batchInsert() throws Exception {
        String tableName = this.getTableName();
        try (Statement stmt = this.connection.createStatement();){
            Assert.assertFalse((boolean)stmt.execute("DROP TABLE IF EXISTS " + tableName));
            String sql = "CREATE TABLE " + tableName + " (pk integer not null primary key, col1 varchar(10))";
            Assert.assertFalse((boolean)stmt.execute(sql));
            for (int i = 0; i < 10; ++i) {
                sql = "INSERT INTO " + tableName + " values (" + i + ", '" + i + "')";
                try {
                    stmt.addBatch(sql);
                    continue;
                }
                catch (SQLFeatureNotSupportedException e) {
                    Assume.assumeTrue((String)"Batch update is not support by the client", (boolean)false);
                }
            }
            int[] updateCounts = stmt.executeBatch();
            int[] expectedUpdateCounts = new int[10];
            Arrays.fill(expectedUpdateCounts, 1);
            Assert.assertArrayEquals((int[])expectedUpdateCounts, (int[])updateCounts);
            ResultSet results = stmt.executeQuery("SELECT * FROM " + tableName);
            Assert.assertNotNull((Object)results);
            for (int i = 0; i < 10; ++i) {
                Assert.assertTrue((boolean)results.next());
                Assert.assertEquals((long)i, (long)results.getInt(1));
                Assert.assertEquals((Object)Integer.toString(i), (Object)results.getString(1));
            }
            Assert.assertFalse((boolean)results.next());
            results.close();
        }
    }

    @Test
    public void preparedBatchInsert() throws Exception {
        String tableName = this.getTableName();
        String insertSql = "INSERT INTO " + tableName + " values(?, ?)";
        try (Statement stmt = this.connection.createStatement();){
            Assert.assertFalse((boolean)stmt.execute("DROP TABLE IF EXISTS " + tableName));
            String sql = "CREATE TABLE " + tableName + " (pk integer not null primary key, col1 varchar(10))";
            Assert.assertFalse((boolean)stmt.execute(sql));
            try (PreparedStatement pstmt = this.connection.prepareStatement(insertSql);){
                for (int i = 0; i < 10; ++i) {
                    pstmt.setInt(1, i);
                    pstmt.setString(2, "a_" + Integer.toString(i));
                    try {
                        pstmt.addBatch();
                        continue;
                    }
                    catch (SQLFeatureNotSupportedException e) {
                        Assume.assumeTrue((String)"Batch update is not support by the client", (boolean)false);
                    }
                }
                int[] updateCounts = pstmt.executeBatch();
                int[] expectedUpdateCounts = new int[10];
                Arrays.fill(expectedUpdateCounts, 1);
                Assert.assertArrayEquals((int[])expectedUpdateCounts, (int[])updateCounts);
            }
            ResultSet results = stmt.executeQuery("SELECT COUNT(pk) from " + tableName);
            Assert.assertNotNull((Object)results);
            Assert.assertTrue((boolean)results.next());
            Assert.assertEquals((long)10L, (long)results.getInt(1));
            results = stmt.executeQuery("SELECT * from " + tableName);
            Assert.assertNotNull((Object)results);
            for (int i = 0; i < 10; ++i) {
                Assert.assertTrue((boolean)results.next());
                Assert.assertEquals((long)i, (long)results.getInt(1));
                Assert.assertEquals((Object)("a_" + i), (Object)results.getString(2));
            }
            Assert.assertFalse((boolean)results.next());
            results.close();
        }
    }

    @Test
    public void commitAndRollback() throws Exception {
        String tableName = this.getTableName();
        this.connection.setAutoCommit(false);
        Assert.assertFalse((boolean)this.connection.getAutoCommit());
        try (Statement stmt = this.connection.createStatement();){
            Assert.assertFalse((boolean)stmt.execute("DROP TABLE IF EXISTS " + tableName));
            String sql = "CREATE TABLE " + tableName + " (pk integer not null primary key, col1 varchar(10))";
            Assert.assertFalse((boolean)stmt.execute(sql));
            for (int i = 0; i < 10; ++i) {
                sql = "INSERT INTO " + tableName + " values (" + i + ", '" + i + "')";
                Assert.assertEquals((long)1L, (long)stmt.executeUpdate(sql));
                if (i != 4) continue;
                this.connection.rollback();
            }
            this.connection.commit();
            ResultSet results = stmt.executeQuery("SELECT * FROM " + tableName);
            Assert.assertNotNull((Object)results);
            for (int i = 5; i < 10; ++i) {
                Assert.assertTrue((boolean)results.next());
                Assert.assertEquals((long)i, (long)results.getInt(1));
                Assert.assertEquals((Object)Integer.toString(i), (Object)results.getString(1));
            }
            Assert.assertFalse((boolean)results.next());
            results.close();
        }
    }
}

