/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.tck.tests;

import java.math.BigDecimal;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.calcite.avatica.tck.tests.BaseTckTest;
import org.junit.Assert;
import org.junit.Test;

public class MetadataTest
extends BaseTckTest {
    @Test
    public void parameterMetadata() throws Exception {
        String tableName = this.getTableName();
        try (Statement stmt = this.getConnection().createStatement();){
            Assert.assertFalse((boolean)stmt.execute("DROP TABLE IF EXISTS " + tableName));
            String sql = "CREATE TABLE " + tableName + " (pk integer not null primary key, col1 DECIMAL(10, 5), col2 boolean not null)";
            Assert.assertFalse((boolean)stmt.execute(sql));
            String insertSql = "INSERT INTO " + tableName + " values(?, ?, ?)";
            try (PreparedStatement pstmt = this.getConnection().prepareStatement(insertSql);){
                ParameterMetaData params = pstmt.getParameterMetaData();
                Assert.assertEquals((long)3L, (long)params.getParameterCount());
                Assert.assertEquals((long)4L, (long)params.getParameterType(1));
                Assert.assertTrue((boolean)params.isSigned(1));
                Assert.assertTrue((0 == params.isNullable(1) || 2 == params.isNullable(1) ? 1 : 0) != 0);
                Assert.assertEquals((long)3L, (long)params.getParameterType(2));
                Assert.assertTrue((boolean)params.isSigned(2));
                Assert.assertTrue((1 == params.isNullable(2) || 2 == params.isNullable(2) ? 1 : 0) != 0);
                Assert.assertEquals((long)10L, (long)params.getPrecision(2));
                Assert.assertEquals((long)5L, (long)params.getScale(2));
                Assert.assertEquals((long)16L, (long)params.getParameterType(3));
                Assert.assertFalse((boolean)params.isSigned(3));
                Assert.assertTrue((0 == params.isNullable(3) || 2 == params.isNullable(3) ? 1 : 0) != 0);
                pstmt.setInt(1, Integer.MAX_VALUE);
                pstmt.setBigDecimal(2, new BigDecimal("12345.12345"));
                pstmt.setBoolean(3, true);
                Assert.assertEquals((long)1L, (long)pstmt.executeUpdate());
                pstmt.setInt(1, Integer.MIN_VALUE);
                pstmt.setBigDecimal(2, new BigDecimal("54321.54321"));
                pstmt.setBoolean(3, false);
                Assert.assertEquals((long)1L, (long)pstmt.executeUpdate());
            }
            ResultSet results = stmt.executeQuery("SELECT * FROM " + tableName + " ORDER BY pk");
            Assert.assertNotNull((Object)results);
            ResultSetMetaData resultMetadata = results.getMetaData();
            Assert.assertEquals((long)3L, (long)resultMetadata.getColumnCount());
            Assert.assertTrue((0 == resultMetadata.isNullable(1) || 2 == resultMetadata.isNullable(1) ? 1 : 0) != 0);
            Assert.assertEquals((long)4L, (long)resultMetadata.getColumnType(1));
            Assert.assertTrue((boolean)resultMetadata.isSigned(1));
            Assert.assertTrue((1 == resultMetadata.isNullable(2) || 2 == resultMetadata.isNullable(2) ? 1 : 0) != 0);
            Assert.assertEquals((long)3L, (long)resultMetadata.getColumnType(2));
            Assert.assertTrue((boolean)resultMetadata.isSigned(2));
            Assert.assertEquals((long)10L, (long)resultMetadata.getPrecision(2));
            Assert.assertEquals((long)5L, (long)resultMetadata.getScale(2));
            Assert.assertTrue((0 == resultMetadata.isNullable(3) || 2 == resultMetadata.isNullable(3) ? 1 : 0) != 0);
            Assert.assertEquals((long)16L, (long)resultMetadata.getColumnType(3));
            Assert.assertFalse((boolean)resultMetadata.isSigned(3));
            Assert.assertTrue((boolean)results.next());
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)results.getInt(1));
            BigDecimal buggyDecimalValue = new BigDecimal("54321.00000");
            BigDecimal expectedDecimalValue = new BigDecimal("54321.54321");
            BigDecimal actualDecimalValue = results.getBigDecimal(2);
            Assert.assertTrue((String)("Unexpected decimal value of " + actualDecimalValue), (expectedDecimalValue.equals(actualDecimalValue) || buggyDecimalValue.equals(actualDecimalValue) ? 1 : 0) != 0);
            Assert.assertEquals((Object)false, (Object)results.getBoolean(3));
            Assert.assertTrue((boolean)results.next());
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)results.getInt(1));
            buggyDecimalValue = new BigDecimal("12345.00000");
            expectedDecimalValue = new BigDecimal("12345.12345");
            actualDecimalValue = results.getBigDecimal(2);
            Assert.assertTrue((String)("Unexpected decimal value of " + actualDecimalValue), (expectedDecimalValue.equals(actualDecimalValue) || buggyDecimalValue.equals(actualDecimalValue) ? 1 : 0) != 0);
            Assert.assertEquals((Object)true, (Object)results.getBoolean(3));
            Assert.assertFalse((boolean)results.next());
        }
    }
}

