/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.tck.tests;

import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.calcite.avatica.tck.tests.BaseTckTest;
import org.junit.Assert;
import org.junit.Test;

public class BinaryTest
extends BaseTckTest {
    @Test
    public void readWriteBinaryData() throws Exception {
        String tableName = this.getTableName();
        try (Statement stmt = this.connection.createStatement();){
            Assert.assertFalse((boolean)stmt.execute("DROP TABLE IF EXISTS " + tableName));
            String sql = "CREATE TABLE " + tableName + " (pk integer not null primary key, col1 binary(10))";
            Assert.assertFalse((boolean)stmt.execute(sql));
            try (PreparedStatement pstmt = this.connection.prepareStatement("INSERT INTO " + tableName + " values (?,?)");){
                for (int i = 0; i < 10; ++i) {
                    pstmt.setInt(1, i);
                    pstmt.setBytes(2, ("bytes" + i).getBytes(StandardCharsets.UTF_8));
                    Assert.assertEquals((long)1L, (long)pstmt.executeUpdate());
                }
            }
            ResultSet results = stmt.executeQuery("SELECT * FROM " + tableName);
            Assert.assertNotNull((Object)results);
            for (int i = 0; i < 10; ++i) {
                Assert.assertTrue((boolean)results.next());
                Assert.assertEquals((long)i, (long)results.getInt(1));
                byte[] expectedContent = ("bytes" + i).getBytes(StandardCharsets.UTF_8);
                byte[] expected = new byte[10];
                System.arraycopy(expectedContent, 0, expected, 0, expectedContent.length);
                Assert.assertArrayEquals((byte[])expected, (byte[])results.getBytes(2));
            }
            Assert.assertFalse((boolean)results.next());
            results.close();
        }
    }

    @Test
    public void selectivelyReadBinaryData() throws Exception {
        String tableName = this.getTableName();
        try (Statement stmt = this.connection.createStatement();){
            Assert.assertFalse((boolean)stmt.execute("DROP TABLE IF EXISTS " + tableName));
            String sql = "CREATE TABLE " + tableName + " (pk integer not null primary key, col1 binary(10))";
            Assert.assertFalse((boolean)stmt.execute(sql));
            try (PreparedStatement pstmt = this.connection.prepareStatement("INSERT INTO " + tableName + " values (?,?)");){
                for (int i = 0; i < 10; ++i) {
                    pstmt.setInt(1, i);
                    pstmt.setBytes(2, ("bytes" + i).getBytes(StandardCharsets.UTF_8));
                    Assert.assertEquals((long)1L, (long)pstmt.executeUpdate());
                }
            }
            pstmt = this.connection.prepareStatement("SELECT * FROM " + tableName + " WHERE col1 = ?");
            var6_8 = null;
            try {
                byte[] expectedContent = "bytes4".getBytes(StandardCharsets.UTF_8);
                byte[] expected = new byte[10];
                System.arraycopy(expectedContent, 0, expected, 0, expectedContent.length);
                pstmt.setBytes(1, expected);
                ResultSet results = pstmt.executeQuery();
                Assert.assertNotNull((Object)results);
                Assert.assertTrue((boolean)results.next());
                Assert.assertEquals((long)4L, (long)results.getInt(1));
                Assert.assertArrayEquals((byte[])expected, (byte[])results.getBytes(2));
                Assert.assertFalse((boolean)results.next());
                results.close();
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (pstmt != null) {
                    if (var6_8 != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        pstmt.close();
                    }
                }
            }
        }
    }
}

