/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.tck;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.avatica.tck.Unsafe;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TestRunner.class);
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static Driver driver;
    private static String driverUrl;
    @Parameter(names={"-u", "--jdbcUrl"}, description="JDBC URL for Avatica Driver")
    private String jdbcUrl;
    private JUnitCore junitCore;

    public static Connection getConnection() throws SQLException {
        if (null == driver) {
            throw new IllegalStateException("JDBC Driver is not initialized");
        }
        return driver.connect(driverUrl, new Properties());
    }

    @Override
    public void run() {
        this.initializeDriver();
        if (null == driver) {
            LOG.error("Failed to find driver for {}", (Object)this.jdbcUrl);
            Unsafe.systemExit(TestRunnerExitCodes.NO_SUCH_DRIVER.ordinal());
            return;
        }
        this.initializeJUnit();
        List<Class<?>> testClasses = this.getAllTestClasses();
        TestResults globalResults = new TestResults();
        for (Class<?> testClass : testClasses) {
            this.runSingleTest(globalResults, testClass);
        }
        System.out.println(globalResults.summarize());
        if (globalResults.numFailed > 0) {
            Unsafe.systemExit(TestRunnerExitCodes.FAILED_TESTS.ordinal());
        } else {
            Unsafe.systemExit(TestRunnerExitCodes.NORMAL.ordinal());
        }
    }

    List<Class<?>> getAllTestClasses() {
        try {
            ClassPath cp = ClassPath.from((ClassLoader)this.getClass().getClassLoader());
            ImmutableSet classes = cp.getTopLevelClasses("org.apache.calcite.avatica.tck.tests");
            ArrayList testClasses = new ArrayList(classes.size());
            for (ClassPath.ClassInfo classInfo : classes) {
                Class<?> clz;
                if (classInfo.getSimpleName().equals("package-info") || Modifier.isAbstract((clz = Class.forName(classInfo.getName())).getModifiers())) continue;
                testClasses.add(clz);
            }
            return testClasses;
        }
        catch (Exception e) {
            LOG.error("Failed to instantiate test classes", (Throwable)e);
            Unsafe.systemExit(TestRunnerExitCodes.TEST_CASE_INSTANTIATION.ordinal());
            return null;
        }
    }

    void initializeDriver() {
        try {
            Class.forName("org.apache.calcite.avatica.remote.Driver");
            driverUrl = this.jdbcUrl;
            driver = DriverManager.getDriver(driverUrl);
        }
        catch (SQLException e) {
            LOG.error("Could not instantiate JDBC Driver with URL: '{}'", (Object)this.jdbcUrl, (Object)e);
            Unsafe.systemExit(TestRunnerExitCodes.BAD_JDBC_URL.ordinal());
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not load Avatica Driver class", (Throwable)e);
            Unsafe.systemExit(TestRunnerExitCodes.MISSING_DRIVER_CLASS.ordinal());
        }
    }

    void initializeJUnit() {
        this.junitCore = new JUnitCore();
        this.junitCore.addListener(new RunListener(){

            public void testStarted(Description description) throws Exception {
                LOG.debug("Starting {}", (Object)description);
            }

            public void testFinished(Description description) throws Exception {
                LOG.debug("{}Finished {}{}", new Object[]{TestRunner.ANSI_GREEN, description, TestRunner.ANSI_RESET});
            }

            public void testFailure(Failure failure) throws Exception {
                LOG.info("{}Failed {}{}", new Object[]{TestRunner.ANSI_RED, failure.getDescription(), TestRunner.ANSI_RESET, failure.getException()});
            }
        });
    }

    void runSingleTest(TestResults globalResults, Class<?> testClass) {
        String className = Objects.requireNonNull(testClass).getName();
        LOG.info("{}Running {}{}", new Object[]{ANSI_GREEN, className, ANSI_RESET});
        try {
            Result result = this.junitCore.run(new Class[]{testClass});
            globalResults.merge(testClass, result);
        }
        catch (Exception e) {
            LOG.error("{}Test failed: {}{}", new Object[]{ANSI_RED, className, ANSI_RESET, e});
        }
    }

    public static void main(String[] args) {
        TestRunner runner = new TestRunner();
        new JCommander((Object)runner, args);
        runner.run();
    }

    private static enum TestRunnerExitCodes {
        NORMAL,
        BAD_JDBC_URL,
        TEST_CASE_INSTANTIATION,
        NO_SUCH_DRIVER,
        FAILED_TESTS,
        MISSING_DRIVER_CLASS;

    }

    private static class TestResults {
        private int numRun = 0;
        private int numFailed = 0;
        private int numIgnored = 0;
        private List<Failure> failures = new ArrayList<Failure>();

        private TestResults() {
        }

        public TestResults merge(Class<?> testClass, Result result) {
            LOG.info("Tests run: {}, Failures: {}, Skipped: {}, Time elapsed: {} - in {}", new Object[]{result.getRunCount(), result.getFailureCount(), result.getIgnoreCount(), TimeUnit.SECONDS.convert(result.getRunTime(), TimeUnit.MILLISECONDS), testClass.getName()});
            this.numRun += result.getRunCount();
            this.numFailed += result.getFailureCount();
            this.numIgnored += result.getIgnoreCount();
            if (!result.wasSuccessful()) {
                this.failures.addAll(result.getFailures());
            }
            return this;
        }

        public String summarize() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("\nTest Summary: Run: ").append(this.numRun).append(", Failed: ").append(this.numFailed);
            sb.append(", Skipped: ").append(this.numIgnored);
            if (this.numFailed > 0) {
                sb.append(TestRunner.ANSI_RED).append("\n\nFailures:").append(TestRunner.ANSI_RESET).append("\n\n");
                for (Failure failure : this.failures) {
                    sb.append(failure.getTestHeader()).append(" ").append(failure.getMessage()).append("\n");
                }
            }
            return sb.toString();
        }
    }
}

