/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.standalone;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.Locale;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.jdbc.JdbcMeta;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.calcite.avatica.remote.LocalService;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.HttpServer;
import org.apache.calcite.avatica.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneServer {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneServer.class);
    @Parameter(names={"-u", "--url"}, required=true, description="JDBC driver url for the server")
    private String url;
    @Parameter(names={"-p", "--port"}, required=false, description="Port the server should bind")
    private int port = 0;
    @Parameter(names={"-s", "--serialization"}, required=false, description="Serialization method to use", converter=SerializationConverter.class)
    private Driver.Serialization serialization = Driver.Serialization.PROTOBUF;
    @Parameter(names={"-h", "-help", "--help"}, required=false, help=true, description="Print the help message")
    private boolean help = false;
    private HttpServer server;

    public void start() {
        if (null != this.server) {
            LOG.error("The server was already started");
            Unsafe.systemExit((int)ExitCodes.ALREADY_STARTED.ordinal());
            return;
        }
        try {
            JdbcMeta meta = new JdbcMeta(this.url);
            LocalService service = new LocalService((Meta)meta);
            this.server = new HttpServer.Builder().withHandler((Service)service, this.serialization).withPort(this.port).build();
            this.server.start();
            LOG.info("Started Avatica server on port {} with serialization {}", (Object)this.server.getPort(), (Object)this.serialization);
        }
        catch (Exception e) {
            LOG.error("Failed to start Avatica server", (Throwable)e);
            Unsafe.systemExit((int)ExitCodes.START_FAILED.ordinal());
        }
    }

    public void stop() {
        if (null != this.server) {
            this.server.stop();
            this.server = null;
        }
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public static void main(String[] args) {
        final StandaloneServer server = new StandaloneServer();
        JCommander jc = new JCommander((Object)server, args);
        if (server.help) {
            jc.usage();
            Unsafe.systemExit((int)ExitCodes.USAGE.ordinal());
            return;
        }
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.info("Stopping server");
                server.stop();
                LOG.info("Server stopped");
            }
        }));
        try {
            server.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private static enum ExitCodes {
        NORMAL,
        ALREADY_STARTED,
        START_FAILED,
        USAGE;

    }

    public static class SerializationConverter
    implements IStringConverter<Driver.Serialization> {
        public Driver.Serialization convert(String value) {
            return Driver.Serialization.valueOf((String)value.toUpperCase(Locale.ROOT));
        }
    }
}

