/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.xml;

import java.util.Map;
import org.apache.bval.example.BusinessObject;
import org.apache.bval.model.MetaBean;
import org.apache.bval.xml.XMLMetaBeanInfos;
import org.apache.bval.xml.XMLMetaBeanLoader;
import org.apache.bval.xml.XMLMetaBeanManager;
import org.apache.bval.xml.XMLMetaBeanURLLoader;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class XMLMetaBeanManagerTest {
    private static XMLMetaBeanManager mbm = new XMLMetaBeanManager();

    @BeforeClass
    public static void setUp() throws Exception {
        mbm.addLoader((XMLMetaBeanLoader)new XMLMetaBeanURLLoader(BusinessObject.class.getResource("test-beanInfos.xml")));
    }

    @Test
    public void testEnrichCopies() throws Exception {
        Map copies = mbm.enrichCopies(new XMLMetaBeanInfos[]{new XMLMetaBeanURLLoader(BusinessObject.class.getResource("test-beanInfos-custom.xml")).load()});
        Assert.assertNotNull((Object)copies);
        MetaBean mb = (MetaBean)copies.get(BusinessObject.class.getName());
        Assert.assertFalse((boolean)mb.getProperty("lastName").isMandatory());
        MetaBean mb2 = mbm.findForClass(BusinessObject.class);
        Assert.assertTrue((boolean)mb2.getProperty("lastName").isMandatory());
    }

    @Test
    public void testCopy() {
        MetaBean mb = mbm.findForClass(BusinessObject.class);
        MetaBean mb2 = (MetaBean)mb.copy();
        XMLMetaBeanManagerTest.assertNotSame(mb, mb2);
        XMLMetaBeanManagerTest.assertNotSame(mb.getProperty("dateBirth"), mb2.getProperty("dateBirth"));
    }

    @Test
    public void testFindForClass() throws Exception {
        XMLMetaBeanManager finder = mbm;
        MetaBean info = finder.findForClass(BusinessObject.class);
        Assert.assertNotNull((Object)info);
        Assert.assertSame((Object)info, (Object)info.getProperty("address").getMetaBean().getProperty("owner").getMetaBean());
        Assert.assertSame((Object)info, (Object)info.getProperty("addresses").getMetaBean().getProperty("owner").getMetaBean());
        Assert.assertTrue((info.getProperty("email").getJavaScriptValidations().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFindAll() {
        Map all = mbm.findAll();
        Assert.assertNotNull((Object)all);
        Map all2 = mbm.findAll();
        Assert.assertEquals((long)all.size(), (long)all2.size());
        Assert.assertSame(all.get(BusinessObject.class.getName()), all2.get(BusinessObject.class.getName()));
        Assert.assertNotNull(all.get(BusinessObject.class.getName()));
        MetaBean bean = (MetaBean)all.get(BusinessObject.class.getName());
        Assert.assertSame((Object)bean, (Object)bean.getProperty("address").getMetaBean().getProperty("owner").getMetaBean());
        Assert.assertSame((Object)bean, (Object)bean.getProperty("addresses").getMetaBean().getProperty("owner").getMetaBean());
    }

    static void assertNotSame(Object o1, Object o2) {
        Assert.assertFalse((o1 == o2 ? 1 : 0) != 0);
    }
}

