/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.xml;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.bval.example.BusinessObject;
import org.apache.bval.example.BusinessObjectAddress;
import org.apache.bval.xml.XMLMapper;
import org.apache.bval.xml.XMLMetaBean;
import org.apache.bval.xml.XMLMetaBeanInfos;
import org.apache.bval.xml.XMLMetaBeanReference;
import org.apache.bval.xml.XMLMetaProperty;
import org.apache.bval.xml.XMLMetaValidator;
import org.junit.Assert;
import org.junit.Test;

public class XMLMetaBeanInfosTest {
    @Test
    public void testBeanInfosToXML() {
        XMLMetaBeanInfos infos = new XMLMetaBeanInfos();
        infos.setBeans(new ArrayList());
        infos.setValidators(new ArrayList());
        XMLMetaValidator validator = new XMLMetaValidator();
        validator.setId("mandatory");
        validator.setJava("org.apache.bval.MandatoryValidator");
        infos.getValidators().add(validator);
        validator = new XMLMetaValidator();
        validator.setId("email");
        validator.setJava("org.apache.bval.EMailValidation");
        infos.getValidators().add(validator);
        XMLMetaBean bean = new XMLMetaBean();
        bean.putFeature("DOMAIN", (Object)"TestProfile");
        bean.putFeature("label-key", (Object)"business-object-label");
        bean.setId("User");
        bean.setImpl(BusinessObject.class.getName());
        bean.setProperties(new ArrayList());
        XMLMetaProperty property = new XMLMetaProperty();
        property.setName("userId");
        property.setMandatory("true");
        bean.getProperties().add(property);
        property = new XMLMetaProperty();
        property.setName("firstName");
        property.setMandatory("true");
        property.setMaxLength(Integer.valueOf(100));
        bean.getProperties().add(property);
        property = new XMLMetaProperty();
        property.setName("lastName");
        property.setMandatory("true");
        property.setMaxLength(Integer.valueOf(100));
        bean.getProperties().add(property);
        property = new XMLMetaProperty();
        property.setName("title");
        property.setMandatory("false");
        property.setMaxLength(Integer.valueOf(10));
        bean.getProperties().add(property);
        property = new XMLMetaProperty();
        property.setName("dateBirth");
        property.setMandatory("false");
        property.setTimeLag("PAST");
        bean.getProperties().add(property);
        property = new XMLMetaProperty();
        property.setName("validTo");
        property.setMandatory("false");
        property.setTimeLag("FUTURE");
        bean.getProperties().add(property);
        property = new XMLMetaProperty();
        property.setName("email");
        property.putFeature("WIDGET", (Object)"entry");
        property.putFeature("TABLE_COLUMN", (Object)true);
        HashMap<String, String> formatterMap = new HashMap<String, String>();
        formatterMap.put("locale", "DE");
        formatterMap.put("style", "info");
        property.putFeature("ajax-formatter", formatterMap);
        property.addValidator("email");
        bean.getProperties().add(property);
        infos.getBeans().add(bean);
        XMLMetaBean bean2 = new XMLMetaBean();
        bean2.setId("Address");
        bean2.setImpl(BusinessObjectAddress.class.getName());
        property = new XMLMetaProperty();
        property.setName("city");
        bean2.putProperty(property);
        property = new XMLMetaProperty();
        property.setName("country");
        property.setMaxLength(Integer.valueOf(10));
        property.setMandatory("true");
        bean2.putProperty(property);
        XMLMetaBeanReference relation = new XMLMetaBeanReference();
        relation.setName("address");
        relation.setBeanId("Address");
        relation.setMandatory("false");
        bean.putBeanRef(relation);
        infos.getBeans().add(bean2);
        String xml = XMLMapper.getInstance().getXStream().toXML((Object)infos);
        XMLMetaBeanInfos infos2 = (XMLMetaBeanInfos)XMLMapper.getInstance().getXStream().fromXML(xml);
        Assert.assertEquals((long)2L, (long)infos2.getBeans().size());
    }

    @Test
    public void testMaxValueParsing() {
        String xml = "\n<beanInfos>  <bean id=\"org.apache.bval.test.model.Profile\">\n    <property name=\"activationDay\" minValue=\"1\" maxValue=\"31\"/>\n    <property name=\"activationMonth\" minValue=\"1\" maxValue=\"12\"/>\n  </bean></beanInfos>";
        XMLMetaBeanInfos beanInfos = (XMLMetaBeanInfos)XMLMapper.getInstance().getXStream().fromXML(xml);
        Assert.assertNotNull((Object)beanInfos);
        Assert.assertEquals((Object)31, (Object)((XMLMetaBean)beanInfos.getBeans().get(0)).getProperty("activationDay").getMaxValue());
        Assert.assertEquals((Object)1, (Object)((XMLMetaBean)beanInfos.getBeans().get(0)).getProperty("activationDay").getMinValue());
    }
}

