/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.bval.BeanValidator;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.ValidationResults;
import org.apache.bval.example.BusinessObject;
import org.apache.bval.example.BusinessObjectAddress;
import org.apache.bval.model.MetaBean;
import org.apache.bval.xml.XMLMetaBeanLoader;
import org.apache.bval.xml.XMLMetaBeanManagerFactory;
import org.apache.bval.xml.XMLMetaBeanURLLoader;
import org.junit.Assert;
import org.junit.Test;

public class BeanValidatorTest {
    @Test
    public void testValidateMapAsBean() {
        XMLMetaBeanManagerFactory.getRegistry().addLoader((XMLMetaBeanLoader)new XMLMetaBeanURLLoader(BusinessObject.class.getResource("test-beanInfos.xml")));
        MetaBean mb = XMLMetaBeanManagerFactory.getFinder().findForId("org.apache.bval.example.Address");
        BusinessObjectAddress adr = new BusinessObjectAddress();
        BeanValidator validator = new BeanValidator();
        ValidationResults results = (ValidationResults)validator.validate((Object)adr, mb);
        Assert.assertEquals((long)2L, (long)((List)results.getErrorsByReason().get("mandatory")).size());
        validator.setTreatMapsLikeBeans(true);
        results = (ValidationResults)validator.validate(new HashMap(), mb);
        Assert.assertFalse((boolean)results.isEmpty());
        Assert.assertEquals((long)2L, (long)((List)results.getErrorsByReason().get("mandatory")).size());
        validator.setTreatMapsLikeBeans(false);
        results = (ValidationResults)validator.validate(new HashMap(), mb);
        Assert.assertTrue((boolean)results.isEmpty());
    }

    @Test
    public void testValidate() {
        MetaBeanFinder finder = XMLMetaBeanManagerFactory.getFinder();
        XMLMetaBeanManagerFactory.getRegistry().addLoader((XMLMetaBeanLoader)new XMLMetaBeanURLLoader(BusinessObject.class.getResource("test-beanInfos.xml")));
        MetaBean info = finder.findForClass(BusinessObject.class);
        BusinessObject object = new BusinessObject();
        object.setAddress(new BusinessObjectAddress());
        object.getAddress().setOwner(object);
        BeanValidator validator = new BeanValidator();
        ValidationResults results = (ValidationResults)validator.validate((Object)object, info);
        Assert.assertTrue((boolean)results.hasErrorForReason("mandatory"));
        Assert.assertTrue((boolean)results.hasError((Object)object, null));
        Assert.assertTrue((boolean)results.hasError((Object)object.getAddress(), null));
        Assert.assertTrue((boolean)((ValidationResults)validator.validateProperty((Object)object, info.getProperty("firstName"))).hasError((Object)object, "firstName"));
        object.setUserId(1L);
        object.setFirstName("Hans");
        object.setLastName("Tester");
        object.setAddress(new BusinessObjectAddress());
        object.getAddress().setOwner(object);
        Assert.assertFalse((boolean)((ValidationResults)validator.validate((Object)object, info)).isEmpty());
        object.getAddress().setCountry("0123456789012345678");
        Assert.assertFalse((boolean)((ValidationResults)validator.validate((Object)object, info)).isEmpty());
        object.getAddress().setCountry("Germany");
        object.setAddresses(new ArrayList<BusinessObjectAddress>());
        object.getAddresses().add(object.getAddress());
        object.getAddresses().add(object.getAddress());
        object.getAddresses().add(object.getAddress());
        Assert.assertTrue((boolean)((ValidationResults)validator.validate((Object)object, info)).isEmpty());
        object.getAddresses().add(object.getAddress());
        Assert.assertFalse((boolean)((ValidationResults)validator.validate((Object)object, info)).isEmpty());
    }
}

