/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.xml;

import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.bval.example.BusinessObject;
import org.apache.bval.model.MetaBean;
import org.apache.bval.xml.XMLMetaBeanInfos;
import org.apache.bval.xml.XMLMetaBeanLoader;
import org.apache.bval.xml.XMLMetaBeanManager;
import org.apache.bval.xml.XMLMetaBeanURLLoader;

public class XMLMetaBeanManagerTest
extends TestCase {
    XMLMetaBeanManager mbm = new XMLMetaBeanManager();

    public XMLMetaBeanManagerTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.mbm.addLoader((XMLMetaBeanLoader)new XMLMetaBeanURLLoader(BusinessObject.class.getResource("test-beanInfos.xml")));
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEnrichCopies() throws Exception {
        Map copies = this.mbm.enrichCopies(new XMLMetaBeanInfos[]{new XMLMetaBeanURLLoader(BusinessObject.class.getResource("test-beanInfos-custom.xml")).load()});
        XMLMetaBeanManagerTest.assertNotNull((Object)copies);
        MetaBean mb = (MetaBean)copies.get(BusinessObject.class.getName());
        XMLMetaBeanManagerTest.assertFalse((boolean)mb.getProperty("lastName").isMandatory());
        MetaBean mb2 = this.mbm.findForClass(BusinessObject.class);
        XMLMetaBeanManagerTest.assertTrue((boolean)mb2.getProperty("lastName").isMandatory());
    }

    public void testCopy() {
        MetaBean mb = this.mbm.findForClass(BusinessObject.class);
        MetaBean mb2 = (MetaBean)mb.copy();
        XMLMetaBeanManagerTest.assertTrue((mb2 != mb ? 1 : 0) != 0);
        XMLMetaBeanManagerTest.assertTrue((mb2.getProperty("dateBirth") != mb.getProperty("dateBirth") ? 1 : 0) != 0);
    }

    public void testFindForClass() throws Exception {
        XMLMetaBeanManager finder = this.mbm;
        MetaBean info = finder.findForClass(BusinessObject.class);
        XMLMetaBeanManagerTest.assertNotNull((Object)info);
        XMLMetaBeanManagerTest.assertTrue((info == info.getProperty("address").getMetaBean().getProperty("owner").getMetaBean() ? 1 : 0) != 0);
        XMLMetaBeanManagerTest.assertTrue((info == info.getProperty("addresses").getMetaBean().getProperty("owner").getMetaBean() ? 1 : 0) != 0);
        XMLMetaBeanManagerTest.assertTrue((info.getProperty("email").getJavaScriptValidations().length > 0 ? 1 : 0) != 0);
    }

    public void testFindAll() {
        Map all = this.mbm.findAll();
        XMLMetaBeanManagerTest.assertNotNull((Object)all);
        Map all2 = this.mbm.findAll();
        XMLMetaBeanManagerTest.assertEquals((int)all.size(), (int)all2.size());
        XMLMetaBeanManagerTest.assertTrue((all.get(BusinessObject.class.getName()) == all2.get(BusinessObject.class.getName()) ? 1 : 0) != 0);
        XMLMetaBeanManagerTest.assertTrue((all.get(BusinessObject.class.getName()) != null ? 1 : 0) != 0);
        MetaBean bean = (MetaBean)all.get(BusinessObject.class.getName());
        XMLMetaBeanManagerTest.assertTrue((bean == bean.getProperty("address").getMetaBean().getProperty("owner").getMetaBean() ? 1 : 0) != 0);
        XMLMetaBeanManagerTest.assertTrue((bean == bean.getProperty("addresses").getMetaBean().getProperty("owner").getMetaBean() ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(XMLMetaBeanManagerTest.class);
    }
}

