/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.routines;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.bval.BeanValidationContext;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;
import org.apache.bval.routines.StandardValidation;

public class StandardValidationTest
extends TestCase
implements ValidationListener {
    private StandardValidation validation;
    private BeanValidationContext<StandardValidationTest> context;
    private List<String> reasons = new ArrayList<String>();
    private MetaProperty metaProperty;
    private String stringValue;
    private Date dateValue;
    private int intValue;

    public StandardValidationTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.validation = new StandardValidation();
        this.context = new BeanValidationContext((ValidationListener)this);
        this.metaProperty = new MetaProperty();
        this.context.setBean((Object)this, null);
        this.context.setMetaProperty(this.metaProperty);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void testValidateMandatory() {
        this.metaProperty.setName("stringValue");
        this.metaProperty.setMandatory(true);
        this.stringValue = "some value";
        this.validation.validateMandatory(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
        this.context.unknownValue();
        this.stringValue = null;
        this.validation.validateMandatory(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.contains("mandatory"));
        this.context.unknownValue();
        this.metaProperty.setMandatory(false);
        this.reasons.clear();
        this.validation.validateMandatory(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
    }

    public void testValidateMaxLength() {
        this.metaProperty.setName("stringValue");
        this.metaProperty.putFeature("maxLen", (Object)5);
        this.stringValue = "1234";
        this.validation.validateMaxLength(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
        this.context.unknownValue();
        this.stringValue = "much too long";
        this.validation.validateMaxLength(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.contains("maxLen"));
    }

    public void testValidateMinLength() {
        this.metaProperty.setName("stringValue");
        this.metaProperty.putFeature("minLen", (Object)5);
        this.stringValue = "123456";
        this.validation.validateMinLength(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
        this.context.unknownValue();
        this.stringValue = "123";
        this.validation.validateMinLength(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.contains("minLen"));
    }

    public void testValidateMaxValue() {
        this.metaProperty.setName("stringValue");
        this.metaProperty.putFeature("maxValue", (Object)"9999");
        this.stringValue = "1111";
        this.validation.validateMaxValue(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
        this.context.unknownValue();
        this.stringValue = "99999";
        this.validation.validateMaxValue(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.contains("maxValue"));
    }

    public void testValidateMinValue() {
        this.metaProperty.setName("stringValue");
        this.metaProperty.putFeature("minValue", (Object)"5555");
        this.stringValue = "8888";
        this.validation.validateMinValue(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
        this.context.unknownValue();
        this.stringValue = "3333";
        this.validation.validateMinValue(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.contains("minValue"));
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void testValidateMinValue_MixedNumber() {
        this.metaProperty.setName("intValue");
        this.metaProperty.putFeature("minValue", (Object)new Long(0L));
        this.intValue = 5;
        this.validation.validateMinValue(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
        this.context.unknownValue();
        this.intValue = -1;
        this.validation.validateMinValue(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.contains("minValue"));
    }

    public void testValidateMinValue_Date_Timestamp() {
        this.metaProperty.setName("dateValue");
        Date dt = new Date();
        this.metaProperty.putFeature("minValue", (Object)dt);
        this.dateValue = new Timestamp(dt.getTime() + 1000L);
        this.validation.validateMinValue(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
        this.context.unknownValue();
        this.dateValue = new Timestamp(dt.getTime() - 1000L);
        this.validation.validateMinValue(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.contains("minValue"));
    }

    public void testValidateMaxValue_AlphabeticString() {
        this.metaProperty.setName("stringValue");
        this.metaProperty.putFeature("maxValue", (Object)"BBBB");
        this.stringValue = "AAAA";
        this.validation.validateMaxValue(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
        this.context.unknownValue();
        this.stringValue = "BBBC";
        this.validation.validateMaxValue(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.contains("maxValue"));
    }

    public void testValidateRegExp() {
        String regexp = "[a-zA-Z\\- \\d]*";
        this.metaProperty.setName("stringValue");
        this.metaProperty.putFeature("regExp", (Object)regexp);
        this.stringValue = "53773";
        this.validation.validateRegExp(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
        this.context.unknownValue();
        this.stringValue = "5355/7";
        this.validation.validateRegExp(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.contains("regExp"));
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void testValidateTimeLag() {
        this.metaProperty.setName("dateValue");
        this.metaProperty.putFeature("timeLag", (Object)"PAST");
        this.dateValue = new Date(System.currentTimeMillis() - 10000L);
        this.validation.validateTimeLag(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.isEmpty());
        this.metaProperty.putFeature("timeLag", (Object)"FUTURE");
        this.validation.validateTimeLag(this.context);
        StandardValidationTest.assertTrue((boolean)this.reasons.contains("timeLag"));
    }

    public static Test suite() {
        return new TestSuite(StandardValidationTest.class);
    }

    public <T extends ValidationListener> void addError(String reason, ValidationContext<T> context) {
        this.reasons.add(reason);
    }

    public <T extends ValidationListener> void addError(ValidationListener.Error error, ValidationContext<T> context) {
        this.reasons.add(error.getReason());
    }
}

