/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    public static <T> ConstraintViolation<T> getViolation(Set<ConstraintViolation<T>> violations, String propertyPath) {
        for (ConstraintViolation<T> each : violations) {
            if (!each.getPropertyPath().toString().equals(propertyPath)) continue;
            return each;
        }
        return null;
    }

    public static <T> int countViolations(Set<ConstraintViolation<T>> violations, String propertyPath) {
        int result = 0;
        for (ConstraintViolation<T> each : violations) {
            if (!each.getPropertyPath().toString().equals(propertyPath)) continue;
            ++result;
        }
        return result;
    }

    public static <T> ConstraintViolation<T> getViolationWithMessage(Set<ConstraintViolation<T>> violations, String message) {
        for (ConstraintViolation<T> each : violations) {
            if (!each.getMessage().equals(message)) continue;
            return each;
        }
        return null;
    }

    public static void failOnModifiable(Collection<?> collection, String description) {
        int size = collection.size();
        try {
            Assert.assertFalse((String)String.format("should not permit modification to %s", description), (boolean)collection.add(null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((String)"constraint descriptor set size changed", (int)size, (int)collection.size());
    }

    public static void assertConstraintTypesFound(ElementDescriptor.ConstraintFinder constraintFinder, Class<? extends Annotation> ... types) {
        block0: for (Class<? extends Annotation> type : types) {
            for (ConstraintDescriptor descriptor : constraintFinder.getConstraintDescriptors()) {
                if (!descriptor.getAnnotation().annotationType().equals(type)) continue;
                continue block0;
            }
            Assert.fail((String)String.format("Missing expected constraint descriptor of type %s", type));
        }
    }
}

