/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.util;

import java.util.Iterator;
import javax.validation.Path;
import javax.validation.ValidationException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.bval.jsr303.util.NodeImpl;
import org.apache.bval.jsr303.util.PathImpl;

public class PathImplTest
extends TestCase {
    public PathImplTest(String name) {
        super(name);
    }

    public void testParsing() {
        String property = "order[3].deliveryAddress.addressline[1]";
        PathImpl path = PathImpl.createPathFromString((String)property);
        PathImplTest.assertEquals((String)property, (String)path.toString());
        Iterator propIter = path.iterator();
        PathImplTest.assertTrue((boolean)propIter.hasNext());
        Path.Node elem = (Path.Node)propIter.next();
        PathImplTest.assertFalse((boolean)elem.isInIterable());
        PathImplTest.assertEquals((String)"order", (String)elem.getName());
        PathImplTest.assertTrue((boolean)propIter.hasNext());
        elem = (Path.Node)propIter.next();
        PathImplTest.assertTrue((boolean)elem.isInIterable());
        PathImplTest.assertEquals((Object)new Integer(3), (Object)elem.getIndex());
        PathImplTest.assertEquals((String)"deliveryAddress", (String)elem.getName());
        PathImplTest.assertTrue((boolean)propIter.hasNext());
        elem = (Path.Node)propIter.next();
        PathImplTest.assertFalse((boolean)elem.isInIterable());
        PathImplTest.assertEquals(null, (Object)elem.getIndex());
        PathImplTest.assertEquals((String)"addressline", (String)elem.getName());
        PathImplTest.assertTrue((boolean)propIter.hasNext());
        elem = (Path.Node)propIter.next();
        PathImplTest.assertTrue((boolean)elem.isInIterable());
        PathImplTest.assertEquals((Object)new Integer(1), (Object)elem.getIndex());
        PathImplTest.assertNull((Object)elem.getName());
        PathImplTest.assertFalse((boolean)propIter.hasNext());
    }

    public void testParseMapBasedProperty() {
        String property = "order[foo].deliveryAddress";
        PathImpl path = PathImpl.createPathFromString((String)property);
        Iterator propIter = path.iterator();
        PathImplTest.assertTrue((boolean)propIter.hasNext());
        Path.Node elem = (Path.Node)propIter.next();
        PathImplTest.assertFalse((boolean)elem.isInIterable());
        PathImplTest.assertEquals((String)"order", (String)elem.getName());
        PathImplTest.assertTrue((boolean)propIter.hasNext());
        elem = (Path.Node)propIter.next();
        PathImplTest.assertTrue((boolean)elem.isInIterable());
        PathImplTest.assertEquals((Object)"foo", (Object)elem.getKey());
        PathImplTest.assertEquals((String)"deliveryAddress", (String)elem.getName());
        PathImplTest.assertFalse((boolean)propIter.hasNext());
    }

    public void testSpecExamples() {
        String fourthAuthor = "authors[3]";
        PathImpl path = PathImpl.createPathFromString((String)fourthAuthor);
        Iterator propIter = path.iterator();
        PathImplTest.assertTrue((boolean)propIter.hasNext());
        Path.Node elem = (Path.Node)propIter.next();
        PathImplTest.assertFalse((boolean)elem.isInIterable());
        PathImplTest.assertEquals((String)"authors", (String)elem.getName());
        PathImplTest.assertTrue((boolean)propIter.hasNext());
        elem = (Path.Node)propIter.next();
        PathImplTest.assertTrue((boolean)elem.isInIterable());
        PathImplTest.assertEquals((int)3, (int)elem.getIndex());
        PathImplTest.assertNull((Object)elem.getName());
        PathImplTest.assertFalse((boolean)propIter.hasNext());
        String firstAuthorCompany = "authors[0].company";
        path = PathImpl.createPathFromString((String)firstAuthorCompany);
        propIter = path.iterator();
        PathImplTest.assertTrue((boolean)propIter.hasNext());
        elem = (Path.Node)propIter.next();
        PathImplTest.assertFalse((boolean)elem.isInIterable());
        PathImplTest.assertEquals((String)"authors", (String)elem.getName());
        PathImplTest.assertTrue((boolean)propIter.hasNext());
        elem = (Path.Node)propIter.next();
        PathImplTest.assertTrue((boolean)elem.isInIterable());
        PathImplTest.assertEquals((int)0, (int)elem.getIndex());
        PathImplTest.assertEquals((String)"company", (String)elem.getName());
        PathImplTest.assertFalse((boolean)propIter.hasNext());
    }

    public void testNull() {
        PathImplTest.assertEquals((Object)PathImpl.createPathFromString(null), (Object)PathImpl.create(null));
        PathImplTest.assertEquals((String)"", (String)PathImpl.create(null).toString());
        PathImpl path = PathImpl.create(null);
        Path.Node node = (Path.Node)path.iterator().next();
        PathImplTest.assertEquals(null, (String)node.getName());
    }

    public void testUnbalancedBraces() {
        try {
            PathImpl.createPathFromString((String)"foo[.bar");
            PathImplTest.fail();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void testIndexInMiddleOfProperty() {
        try {
            PathImpl.createPathFromString((String)"f[1]oo.bar");
            PathImplTest.fail();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void testTrailingPathSeparator() {
        try {
            PathImpl.createPathFromString((String)"foo.bar.");
            PathImplTest.fail();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void testLeadingPathSeparator() {
        try {
            PathImpl.createPathFromString((String)".foo.bar");
            PathImplTest.fail();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void testEmptyString() {
        PathImpl path = PathImpl.createPathFromString((String)"");
        PathImplTest.assertEquals(null, (String)((Path.Node)path.iterator().next()).getName());
    }

    public void testToString() {
        PathImpl path = PathImpl.create(null);
        path.addNode((Path.Node)new NodeImpl("firstName"));
        PathImplTest.assertEquals((String)"firstName", (String)path.toString());
        path = PathImpl.create(null);
        path.getLeafNode().setIndex(Integer.valueOf(2));
        PathImplTest.assertEquals((String)"[2]", (String)path.toString());
        path.addNode((Path.Node)new NodeImpl("firstName"));
        PathImplTest.assertEquals((String)"[2].firstName", (String)path.toString());
    }

    public void testAddRemoveNodes() {
        PathImpl path = PathImpl.createPathFromString((String)"");
        PathImplTest.assertTrue((boolean)path.isRootPath());
        PathImplTest.assertEquals((int)1, (int)this.countNodes((Path)path));
        path.addNode((Path.Node)new NodeImpl("foo"));
        PathImplTest.assertFalse((boolean)path.isRootPath());
        PathImplTest.assertEquals((int)1, (int)this.countNodes((Path)path));
        path.removeLeafNode();
        PathImplTest.assertTrue((boolean)path.isRootPath());
        PathImplTest.assertEquals((int)1, (int)this.countNodes((Path)path));
    }

    private int countNodes(Path path) {
        int result = 0;
        Iterator iter = path.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++result;
        }
        return result;
    }

    public static Test suite() {
        return new TestSuite(PathImplTest.class);
    }
}

