/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.groups.redefining;

import java.util.Set;
import javax.validation.GroupDefinitionException;
import javax.validation.Validator;
import junit.framework.TestCase;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.groups.redefining.Address;
import org.apache.bval.jsr303.groups.redefining.InvalidRedefinedDefaultGroupAddress;
import org.apache.bval.jsr303.util.TestUtils;

public class RedefiningDefaultGroupTest
extends TestCase {
    private Validator validator;

    protected void setUp() {
        this.validator = ApacheValidatorFactory.getDefault().getValidator();
    }

    public void testValidateDefaultGroup() {
        Address address = new Address();
        Set violations = this.validator.validate((Object)address, new Class[0]);
        RedefiningDefaultGroupTest.assertEquals((int)3, (int)violations.size());
        RedefiningDefaultGroupTest.assertNotNull(TestUtils.getViolation(violations, "street1"));
        RedefiningDefaultGroupTest.assertNotNull(TestUtils.getViolation(violations, "zipCode"));
        RedefiningDefaultGroupTest.assertNotNull(TestUtils.getViolation(violations, "city"));
        address.setStreet1("Elmstreet");
        address.setZipCode("1234");
        address.setCity("Gotham City");
        violations = this.validator.validate((Object)address, new Class[0]);
        RedefiningDefaultGroupTest.assertTrue((boolean)violations.isEmpty());
        violations = this.validator.validate((Object)address, new Class[]{Address.HighLevelCoherence.class});
        RedefiningDefaultGroupTest.assertEquals((int)0, (int)violations.size());
        address.setCity("error");
        violations = this.validator.validate((Object)address, new Class[]{Address.HighLevelCoherence.class});
        RedefiningDefaultGroupTest.assertEquals((int)1, (int)violations.size());
        violations = this.validator.validate((Object)address, new Class[0]);
        RedefiningDefaultGroupTest.assertEquals((String)"redefined default group for Address must also validate HighLevelCoherence", (int)1, (int)violations.size());
    }

    public void testValidateProperty() {
        Address address = new Address();
        address.setStreet1("");
        Set violations = this.validator.validateProperty((Object)address, "street1", new Class[0]);
        RedefiningDefaultGroupTest.assertEquals((int)1, (int)violations.size());
        RedefiningDefaultGroupTest.assertNotNull(TestUtils.getViolation(violations, "street1"));
    }

    public void testValidateValue() {
        Set violations = this.validator.validateValue(Address.class, "street1", (Object)"", new Class[0]);
        RedefiningDefaultGroupTest.assertEquals((int)1, (int)violations.size());
        RedefiningDefaultGroupTest.assertNotNull(TestUtils.getViolation(violations, "street1"));
    }

    public void testRaiseGroupDefinitionException() {
        InvalidRedefinedDefaultGroupAddress address = new InvalidRedefinedDefaultGroupAddress();
        try {
            this.validator.validate((Object)address, new Class[0]);
            RedefiningDefaultGroupTest.fail();
        }
        catch (GroupDefinitionException groupDefinitionException) {
            // empty catch block
        }
    }
}

