/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.groups;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import junit.framework.TestCase;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.groups.Billable;
import org.apache.bval.jsr303.groups.BillableUser;
import org.apache.bval.jsr303.groups.BuyInOneClick;
import org.apache.bval.jsr303.util.TestUtils;

public class GroupValidationTest
extends TestCase {
    private Validator validator;

    protected void setUp() {
        this.validator = ApacheValidatorFactory.getDefault().getValidator();
    }

    public void testValidateFirstNameLastNameWithDefaultGroup() {
        BillableUser user = new BillableUser();
        Set violations = this.validator.validate((Object)user, new Class[0]);
        GroupValidationTest.assertEquals((int)2, (int)violations.size());
        ConstraintViolation violation = TestUtils.getViolation(violations, "firstname");
        GroupValidationTest.assertNotNull(violation);
        GroupValidationTest.assertEquals((Object)user, (Object)violation.getRootBean());
        violation = TestUtils.getViolation(violations, "lastname");
        GroupValidationTest.assertNotNull(violation);
        GroupValidationTest.assertEquals((Object)user, (Object)violation.getRootBean());
    }

    public void testValidateDefaultCreditCardInBillableGroup() {
        BillableUser user = new BillableUser();
        Set violations = this.validator.validate((Object)user, new Class[]{Billable.class});
        GroupValidationTest.assertEquals((int)1, (int)violations.size());
        ConstraintViolation violation = TestUtils.getViolation(violations, "defaultCreditCard");
        GroupValidationTest.assertNotNull(violation);
        GroupValidationTest.assertEquals((Object)user, (Object)violation.getRootBean());
    }

    public void testValidateDefaultCreditCardInBillableAndByInOneClickGroup() {
        BillableUser user = new BillableUser();
        Set violations = this.validator.validate((Object)user, new Class[]{BuyInOneClick.class, Billable.class});
        GroupValidationTest.assertEquals((int)1, (int)violations.size());
        ConstraintViolation violation = TestUtils.getViolation(violations, "defaultCreditCard");
        GroupValidationTest.assertNotNull(violation);
        GroupValidationTest.assertEquals((Object)user, (Object)violation.getRootBean());
    }
}

