/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.groups;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.GroupSequence;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.DefaultMessageInterpolator;
import org.apache.bval.jsr303.example.Author;
import org.apache.bval.jsr303.example.Book;
import org.apache.bval.jsr303.example.First;
import org.apache.bval.jsr303.example.Last;
import org.apache.bval.jsr303.example.Second;
import org.apache.bval.jsr303.groups.GClass1;
import org.apache.bval.jsr303.groups.GClass2;
import org.apache.bval.jsr303.groups.GClass3;
import org.apache.bval.jsr303.groups.GInterface1;
import org.apache.bval.jsr303.groups.Group;
import org.apache.bval.jsr303.util.TestUtils;
import org.apache.bval.model.MetaBean;

public class GroupSequenceTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    private Validator getValidator() {
        return factory.getValidator();
    }

    public void testGroupSequence1() {
        MetaBean metaBean = ApacheValidatorFactory.getDefault().usingContext().getMetaBeanFinder().findForClass(GInterface1.class);
        List gseq = (List)metaBean.getFeature("GroupSequence");
        Assert.assertNotNull((Object)gseq);
        Assert.assertEquals((int)1, (int)gseq.size());
        Assert.assertEquals((Object)Group.DEFAULT, gseq.get(0));
    }

    public void testGroupSequence2() {
        MetaBean metaBean = ApacheValidatorFactory.getDefault().usingContext().getMetaBeanFinder().findForClass(GClass1.class);
        List gseq = (List)metaBean.getFeature("GroupSequence");
        Assert.assertNotNull((Object)gseq);
        Assert.assertEquals((int)1, (int)gseq.size());
        Assert.assertEquals((Object)Group.DEFAULT, gseq.get(0));
    }

    public void testGroupSequence3() {
        MetaBean metaBean = ApacheValidatorFactory.getDefault().usingContext().getMetaBeanFinder().findForClass(GClass2.class);
        List gseq = (List)metaBean.getFeature("GroupSequence");
        Assert.assertNotNull((Object)gseq);
        Assert.assertEquals((int)2, (int)gseq.size());
        Assert.assertEquals((Object)new Group(GClass1.class), gseq.get(0));
        Assert.assertEquals((Object)Group.DEFAULT, gseq.get(1));
    }

    public void testGroupSequence4() {
        MetaBean metaBean = ApacheValidatorFactory.getDefault().usingContext().getMetaBeanFinder().findForClass(GClass3.class);
        List gseq = (List)metaBean.getFeature("GroupSequence");
        Assert.assertNotNull((Object)gseq);
        Assert.assertEquals((int)2, (int)gseq.size());
        Assert.assertEquals((Object)Group.DEFAULT, gseq.get(0));
        Assert.assertEquals((Object)new Group(GClass1.class), gseq.get(1));
    }

    public void testGroups() {
        Validator validator = this.getValidator();
        Author author = new Author();
        author.setLastName("");
        author.setFirstName("");
        Book book = new Book();
        book.setTitle("");
        book.setAuthor(author);
        Set constraintViolations = validator.validate((Object)book, new Class[]{First.class, Second.class, Last.class});
        GroupSequenceTest.assertEquals((String)"Wrong number of constraints", (int)3, (int)constraintViolations.size());
        GroupSequenceTest.assertNotNull(TestUtils.getViolation(constraintViolations, "title"));
        GroupSequenceTest.assertNotNull(TestUtils.getViolation(constraintViolations, "author.firstName"));
        GroupSequenceTest.assertNotNull(TestUtils.getViolation(constraintViolations, "author.lastName"));
        author.setFirstName("Gavin");
        author.setLastName("King");
        constraintViolations = validator.validate((Object)book, new Class[]{First.class, Second.class, Last.class});
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        GroupSequenceTest.assertEquals((int)1, (int)constraintViolations.size());
        GroupSequenceTest.assertEquals((String)"may not be empty", (String)constraintViolation.getMessage());
        GroupSequenceTest.assertEquals((Object)book, (Object)constraintViolation.getRootBean());
        GroupSequenceTest.assertEquals((Object)book.getTitle(), (Object)constraintViolation.getInvalidValue());
        GroupSequenceTest.assertEquals((String)"title", (String)constraintViolation.getPropertyPath().toString());
        book.setTitle("My fault");
        book.setSubtitle("confessions of a president - a book for a nice price");
        constraintViolations = validator.validate((Object)book, new Class[]{First.class, Second.class, Last.class});
        GroupSequenceTest.assertEquals((int)1, (int)constraintViolations.size());
        constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        GroupSequenceTest.assertEquals((String)"size must be between 0 and 30", (String)constraintViolation.getMessage());
        GroupSequenceTest.assertEquals((Object)book, (Object)constraintViolation.getRootBean());
        GroupSequenceTest.assertEquals((Object)book.getSubtitle(), (Object)constraintViolation.getInvalidValue());
        GroupSequenceTest.assertEquals((String)"subtitle", (String)constraintViolation.getPropertyPath().toString());
        book.setSubtitle("Capitalism in crisis");
        author.setCompany("1234567890\u00df9876543212578909876542245678987432");
        constraintViolations = validator.validate((Object)book, new Class[0]);
        constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        GroupSequenceTest.assertEquals((int)1, (int)constraintViolations.size());
        GroupSequenceTest.assertEquals((String)"size must be between 0 and 40", (String)constraintViolation.getMessage());
        GroupSequenceTest.assertEquals((Object)book, (Object)constraintViolation.getRootBean());
        GroupSequenceTest.assertEquals((Object)author.getCompany(), (Object)constraintViolation.getInvalidValue());
        GroupSequenceTest.assertEquals((String)"author.company", (String)constraintViolation.getPropertyPath().toString());
        author.setCompany("apache");
        constraintViolations = validator.validate((Object)book, new Class[]{First.class, Second.class, Last.class});
        GroupSequenceTest.assertEquals((int)0, (int)constraintViolations.size());
    }

    public void testGroupSequence() {
        Validator validator = this.getValidator();
        Author author = new Author();
        author.setLastName("");
        author.setFirstName("");
        Book book = new Book();
        book.setAuthor(author);
        Set constraintViolations = validator.validate((Object)book, new Class[]{Book.All.class});
        GroupSequenceTest.assertEquals((int)2, (int)constraintViolations.size());
        author.setFirstName("Kelvin");
        author.setLastName("Cline");
        constraintViolations = validator.validate((Object)book, new Class[]{Book.All.class});
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        GroupSequenceTest.assertEquals((int)1, (int)constraintViolations.size());
        GroupSequenceTest.assertEquals((String)"may not be null", (String)constraintViolation.getMessage());
        GroupSequenceTest.assertEquals((Object)book, (Object)constraintViolation.getRootBean());
        GroupSequenceTest.assertEquals((Object)book.getTitle(), (Object)constraintViolation.getInvalidValue());
        GroupSequenceTest.assertEquals((String)"title", (String)constraintViolation.getPropertyPath().toString());
        book.setTitle("247307892430798789024389798789");
        book.setSubtitle("f43u rl\u00f6k fj\u00f6q3liu opiur \u00f6lw3kj r\u00f6lkj d");
        constraintViolations = validator.validate((Object)book, new Class[]{Book.All.class});
        GroupSequenceTest.assertEquals((int)1, (int)constraintViolations.size());
    }

    public void testValidationStopsWhenFailuresOnGroup() {
        Validator validator = this.getValidator();
        Set violations = validator.validate((Object)new Dummy(), new Class[0]);
        GroupSequenceTest.assertEquals((String)"Only 1 violation expected", (int)1, (int)violations.size());
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        GroupSequenceTest.assertEquals((String)"Group1 should be evaluated first", (String)"field1", (String)violation.getPropertyPath().toString());
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    @GroupSequence(value={Group1.class, Dummy.class})
    public static class Dummy {
        @NotNull(groups={Group1.class})
        public String field1;
        @NotNull
        public String field2;

        static interface Group1 {
        }
    }
}

