/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.groups;

import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.GroupSequence;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.jsr303.DefaultMessageInterpolator;

public class GroupSequenceIsolationTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    private Validator getValidator() {
        return factory.getValidator();
    }

    public void testGroupSequencesInHierarchyClasses() {
        boolean good;
        Validator validator = this.getValidator();
        HolderWithNoGS h = new HolderWithNoGS();
        Set violations = validator.validate((Object)h, new Class[0]);
        Assert.assertEquals((String)"Unexpected number of violations", (int)2, (int)violations.size());
        for (ConstraintViolation violation : violations) {
            good = violation.getPropertyPath().toString().equals("a1");
            Assert.assertTrue((String)"Wrong constraint", (boolean)(good |= violation.getPropertyPath().toString().equals("b2")));
        }
        h.a1 = "good";
        violations = validator.validate((Object)h, new Class[0]);
        Assert.assertEquals((String)"Unexpected number of violations", (int)2, (int)violations.size());
        for (ConstraintViolation violation : violations) {
            good = violation.getPropertyPath().toString().equals("a2");
            Assert.assertTrue((String)"Wrong constraint", (boolean)(good |= violation.getPropertyPath().toString().equals("b2")));
        }
        h.b2 = "good";
        violations = validator.validate((Object)h, new Class[0]);
        Assert.assertEquals((String)"Unexpected number of violations", (int)2, (int)violations.size());
        for (ConstraintViolation violation : violations) {
            good = violation.getPropertyPath().toString().equals("a2");
            Assert.assertTrue((String)"Wrong constraint", (boolean)(good |= violation.getPropertyPath().toString().equals("b1")));
        }
        h.b1 = "good";
        violations = validator.validate((Object)h, new Class[0]);
        Assert.assertEquals((String)"Unexpected number of violations", (int)1, (int)violations.size());
        for (ConstraintViolation violation : violations) {
            good = violation.getPropertyPath().toString().equals("a2");
            Assert.assertTrue((String)"Wrong constraint", (boolean)good);
        }
    }

    public void testGroupSequenceOfBeanClass() {
        boolean good;
        Validator validator = this.getValidator();
        HolderWithGS h = new HolderWithGS();
        Set violations = validator.validate((Object)h, new Class[0]);
        Assert.assertEquals((String)"Unexpected number of violations", (int)1, (int)violations.size());
        for (ConstraintViolation violation : violations) {
            good = violation.getPropertyPath().toString().equals("a1");
            Assert.assertTrue((String)"Wrong constraint", (boolean)good);
        }
        h.a1 = "good";
        violations = validator.validate((Object)h, new Class[0]);
        Assert.assertEquals((String)"Unexpected number of violations", (int)2, (int)violations.size());
        for (ConstraintViolation violation : violations) {
            good = violation.getPropertyPath().toString().equals("a2");
            Assert.assertTrue((String)"Wrong constraint", (boolean)(good |= violation.getPropertyPath().toString().equals("b2")));
        }
        h.a2 = "good";
        h.b2 = "good";
        violations = validator.validate((Object)h, new Class[0]);
        Assert.assertEquals((String)"Unexpected number of violations", (int)1, (int)violations.size());
        for (ConstraintViolation violation : violations) {
            good = violation.getPropertyPath().toString().equals("b1");
            Assert.assertTrue((String)"Wrong constraint", (boolean)good);
        }
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    @GroupSequence(value={GroupA1.class, HolderWithGS.class, GroupB1.class})
    public static class HolderWithGS
    extends B {
    }

    public static class HolderWithNoGS
    extends B {
    }

    public static interface GroupB1 {
    }

    @GroupSequence(value={B.class, GroupB1.class})
    public static class B
    extends A {
        @NotNull(groups={GroupB1.class})
        public String b1;
        @NotNull
        public String b2;
    }

    public static interface GroupA1 {
    }

    @GroupSequence(value={GroupA1.class, A.class})
    public static class A {
        @NotNull(groups={GroupA1.class})
        public String a1;
        @NotNull
        public String a2;
    }
}

