/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.extensions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.bval.jsr303.ClassValidator;
import org.apache.bval.jsr303.extensions.ExampleMethodService;
import org.apache.bval.jsr303.extensions.MethodValidator;
import org.apache.bval.jsr303.extensions.MethodValidatorImpl;
import org.apache.bval.jsr303.extensions.MethodValidatorMetaBeanFactory;

public class MethodValidatorImplTest
extends TestCase {
    public MethodValidatorImplTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MethodValidatorImplTest.class);
    }

    public void testUnwrap() {
        ClassValidator cv;
        Validator v = this.getValidator();
        MethodValidatorImplTest.assertTrue((v == (cv = (ClassValidator)v.unwrap(ClassValidator.class)) ? 1 : 0) != 0);
        MethodValidatorImplTest.assertTrue((v == v.unwrap(Validator.class) ? 1 : 0) != 0);
        MethodValidatorImpl mvi = (MethodValidatorImpl)v.unwrap(MethodValidatorImpl.class);
        MethodValidatorImplTest.assertNotNull((Object)mvi);
        MethodValidator mv = (MethodValidator)v.unwrap(MethodValidator.class);
        MethodValidatorImplTest.assertNotNull((Object)mv);
        MethodValidatorImplTest.assertTrue((mv == mv.unwrap(MethodValidatorImpl.class) ? 1 : 0) != 0);
        MethodValidatorImplTest.assertTrue((mv == mv.unwrap(ClassValidator.class) ? 1 : 0) != 0);
    }

    public void testValidateMethodParameters() throws NoSuchMethodException {
        ExampleMethodService service = new ExampleMethodService();
        MethodValidator mv = (MethodValidator)this.getValidator().unwrap(MethodValidator.class);
        Method method = service.getClass().getMethod("concat", String.class, String.class);
        Object[] params = new String[]{"Hello ", "world"};
        Set results = mv.validateParameters(service.getClass(), method, params, new Class[0]);
        MethodValidatorImplTest.assertEquals((boolean)true, (boolean)results.isEmpty());
        params[0] = "";
        results = mv.validateParameters(service.getClass(), method, params, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)1, (int)results.size());
        params[1] = null;
        results = mv.validateParameters(service.getClass(), method, params, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)2, (int)results.size());
        results = mv.validateParameter(service.getClass(), method, params[0], 0, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)1, (int)results.size());
        results = mv.validateParameter(service.getClass(), method, (Object)"ok", 0, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)0, (int)results.size());
    }

    public void testValidateMoreMethodParameters() throws NoSuchMethodException {
        ExampleMethodService service = new ExampleMethodService();
        MethodValidator mv = (MethodValidator)this.getValidator().unwrap(MethodValidator.class);
        Method saveMethod = service.getClass().getMethod("save", String.class);
        Object[] saveParams = new String[]{"abcd"};
        Set results = mv.validateParameters(service.getClass(), saveMethod, saveParams, new Class[0]);
        MethodValidatorImplTest.assertTrue((boolean)results.isEmpty());
        saveParams[0] = "zzzz";
        results = mv.validateParameters(service.getClass(), saveMethod, saveParams, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)1, (int)results.size());
        Method echoMethod = service.getClass().getMethod("echo", String.class);
        Object[] echoParams = new String[]{"hello"};
        results = mv.validateParameters(service.getClass(), echoMethod, echoParams, new Class[0]);
        MethodValidatorImplTest.assertTrue((boolean)results.isEmpty());
        echoParams[0] = "h";
        results = mv.validateParameters(service.getClass(), echoMethod, echoParams, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)1, (int)results.size());
        echoParams[0] = null;
        results = mv.validateParameters(service.getClass(), echoMethod, echoParams, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)1, (int)results.size());
    }

    public void testValidateConstructorParameters() throws NoSuchMethodException {
        ExampleMethodService service = new ExampleMethodService();
        MethodValidator mv = (MethodValidator)this.getValidator().unwrap(MethodValidator.class);
        Constructor<?> constructor = service.getClass().getConstructor(String.class, String.class);
        Object[] params = new String[]{"Hello ", "world"};
        Set results = mv.validateParameters(service.getClass(), constructor, params, new Class[0]);
        MethodValidatorImplTest.assertEquals((boolean)true, (boolean)results.isEmpty());
        params[0] = "";
        results = mv.validateParameters(service.getClass(), constructor, params, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)1, (int)results.size());
        params[1] = null;
        results = mv.validateParameters(service.getClass(), constructor, params, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)2, (int)results.size());
        results = mv.validateParameter(service.getClass(), constructor, params[0], 0, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)1, (int)results.size());
        results = mv.validateParameter(service.getClass(), constructor, (Object)"ok", 0, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)0, (int)results.size());
    }

    public void testValidateReturnValue() throws NoSuchMethodException {
        ExampleMethodService service = new ExampleMethodService();
        MethodValidator mv = (MethodValidator)this.getValidator().unwrap(MethodValidator.class);
        Method method = service.getClass().getMethod("concat", String.class, String.class);
        Set results = mv.validateReturnedValue(service.getClass(), method, (Object)"test", new Class[0]);
        MethodValidatorImplTest.assertEquals((boolean)true, (boolean)results.isEmpty());
        results = mv.validateReturnedValue(service.getClass(), method, (Object)"", new Class[0]);
        MethodValidatorImplTest.assertEquals((int)1, (int)results.size());
    }

    public void testValidateMoreReturnValue() throws NoSuchMethodException {
        ExampleMethodService service = new ExampleMethodService();
        MethodValidator mv = (MethodValidator)this.getValidator().unwrap(MethodValidator.class);
        Method echoMethod = service.getClass().getMethod("echo", String.class);
        String returnedValue = "a too long string";
        Set results = mv.validateReturnedValue(service.getClass(), echoMethod, (Object)returnedValue, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)1, (int)results.size());
        returnedValue = null;
        results = mv.validateReturnedValue(service.getClass(), echoMethod, (Object)returnedValue, new Class[0]);
        MethodValidatorImplTest.assertEquals((int)1, (int)results.size());
        returnedValue = "valid";
        results = mv.validateReturnedValue(service.getClass(), echoMethod, (Object)returnedValue, new Class[0]);
        MethodValidatorImplTest.assertTrue((boolean)results.isEmpty());
    }

    public void testValidateValidParam() throws NoSuchMethodException {
        ExampleMethodService service = new ExampleMethodService();
        MethodValidator mv = (MethodValidator)this.getValidator().unwrap(MethodValidator.class);
        Method personOp1 = service.getClass().getMethod("personOp1", ExampleMethodService.Person.class);
        ExampleMethodService.Person p = new ExampleMethodService.Person();
        Set results = mv.validateParameters(service.getClass(), personOp1, new Object[]{p}, new Class[0]);
        MethodValidatorImplTest.assertEquals((String)"Expected 1 violation", (int)1, (int)results.size());
        p.name = "valid name";
        results = mv.validateParameters(service.getClass(), personOp1, new Object[]{p}, new Class[0]);
        MethodValidatorImplTest.assertTrue((String)"No violations expected", (boolean)results.isEmpty());
        results = mv.validateParameters(service.getClass(), personOp1, new Object[]{null}, new Class[0]);
        MethodValidatorImplTest.assertTrue((String)"No violations expected", (boolean)results.isEmpty());
    }

    public void testValidateNotNullValidParam() throws NoSuchMethodException {
        ExampleMethodService service = new ExampleMethodService();
        MethodValidator mv = (MethodValidator)this.getValidator().unwrap(MethodValidator.class);
        Method personOp2 = service.getClass().getMethod("personOp2", ExampleMethodService.Person.class);
        Set results = mv.validateParameters(service.getClass(), personOp2, new Object[]{null}, new Class[0]);
        MethodValidatorImplTest.assertEquals((String)"Expected 1 violation", (int)1, (int)results.size());
        ExampleMethodService.Person p = new ExampleMethodService.Person();
        results = mv.validateParameters(service.getClass(), personOp2, new Object[]{p}, new Class[0]);
        MethodValidatorImplTest.assertEquals((String)"Expected 1 violation", (int)1, (int)results.size());
        p.name = "valid name";
        results = mv.validateParameters(service.getClass(), personOp2, new Object[]{p}, new Class[0]);
        MethodValidatorImplTest.assertTrue((String)"No violations expected", (boolean)results.isEmpty());
    }

    public void testValidateImplementedMethod() throws NoSuchMethodException {
        UserMethodsImpl um = new UserMethodsImpl();
        MethodValidator mv = (MethodValidator)this.getValidator().unwrap(MethodValidator.class);
        Method classMethod = um.getClass().getMethod("findUser", String.class, String.class, Integer.class);
        Method ifaceMethod = UserMethods.class.getMethod("findUser", String.class, String.class, Integer.class);
        Set results = mv.validateParameters(um.getClass(), classMethod, new Object[]{"", "valid", null}, new Class[0]);
        MethodValidatorImplTest.assertEquals((String)"Invalid number of violations", (int)2, (int)results.size());
        results = mv.validateParameters(UserMethods.class, ifaceMethod, new Object[]{"", "valid", null}, new Class[0]);
        MethodValidatorImplTest.assertEquals((String)"Invalid number of violations", (int)0, (int)results.size());
        try {
            results = mv.validateParameters(UserMethods.class, classMethod, new Object[]{"", "valid", null}, new Class[0]);
            Assert.fail((String)"Exception not thrown when validating interface.class + impl.method");
        }
        catch (ValidationException e) {
            // empty catch block
        }
        try {
            results = mv.validateParameters(um.getClass(), ifaceMethod, new Object[]{"", "valid", null}, new Class[0]);
            Assert.fail((String)"Exception not thrown when validating impl.class + interface.method");
        }
        catch (ValidationException e) {
            // empty catch block
        }
    }

    private Validator getValidator() {
        return ((ApacheValidatorConfiguration)((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).addProperty("apache.bval.metabean-factory-classnames", MethodValidatorMetaBeanFactory.class.getName())).buildValidatorFactory().getValidator();
    }

    public static class UserMethodsImpl
    implements UserMethods {
        public void findUser(@Size(min=1) String param1, @NotNull String param2, @NotNull Integer param3) {
        }
    }

    public static interface UserMethods {
        public void findUser(String var1, String var2, Integer var3);
    }
}

