/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import javax.validation.Constraint;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import junit.framework.TestCase;
import org.apache.bval.jsr303.DefaultMessageInterpolator;

public class ValidatorResolutionTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    protected Validator validator;

    public void setUp() throws Exception {
        super.setUp();
        this.validator = this.createValidator();
    }

    protected Validator createValidator() {
        return factory.getValidator();
    }

    public void testInvalidValidator() {
        try {
            this.validator.validate((Object)new Person(), new Class[0]);
            ValidatorResolutionTest.fail((String)"No exception thrown, but no valid validator available.");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvalidPersonNameValidator
    implements ConstraintValidator<NotNull, String> {
        public void initialize(NotNull constraintAnnotation) {
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Constraint(validatedBy={InvalidPersonNameValidator.class})
    @Documented
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PersonName {
        public String message() default "Wrong person name";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static class Person {
        @PersonName
        public String name;
    }
}

