/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.constraints.NotNullValidator;
import org.apache.bval.jsr303.CascadingPropertyValidator;
import org.apache.bval.jsr303.DefaultMessageInterpolator;
import org.apache.bval.jsr303.example.AccessTestBusinessObject;
import org.apache.bval.jsr303.example.AccessTestBusinessObjectSub;
import org.apache.bval.jsr303.example.Address;
import org.apache.bval.jsr303.example.Author;
import org.apache.bval.jsr303.example.Book;
import org.apache.bval.jsr303.example.BusinessAddress;
import org.apache.bval.jsr303.example.Continent;
import org.apache.bval.jsr303.example.Country;
import org.apache.bval.jsr303.example.First;
import org.apache.bval.jsr303.example.Last;
import org.apache.bval.jsr303.example.RecursiveFoo;
import org.apache.bval.jsr303.util.TestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    protected Validator validator;

    public void setUp() throws Exception {
        super.setUp();
        this.validator = this.createValidator();
    }

    protected Validator createValidator() {
        return factory.getValidator();
    }

    public void testAccessStrategies_field_method() {
        AccessTestBusinessObject o1 = new AccessTestBusinessObject("1");
        AccessTestBusinessObjectSub o2 = new AccessTestBusinessObjectSub("3");
        Set errors = this.validator.validate((Object)o1, new Class[0]);
        ValidationTest.assertTrue((boolean)errors.isEmpty());
        Set errors2 = this.validator.validate((Object)o2, new Class[0]);
        ValidationTest.assertTrue((boolean)errors2.isEmpty());
        o2 = new AccessTestBusinessObjectSub("1");
        errors2 = this.validator.validate((Object)o2, new Class[0]);
        ValidationTest.assertEquals((int)1, (int)errors2.size());
        o2 = new AccessTestBusinessObjectSub("3");
        o2.setVar2("1");
        o2.setvar2("2");
        errors2 = this.validator.validate((Object)o2, new Class[0]);
        ValidationTest.assertEquals((int)2, (int)errors2.size());
        o2.setvar2("5");
        o2.setVar2("6");
        errors2 = this.validator.validate((Object)o2, new Class[0]);
        ValidationTest.assertEquals((int)0, (int)errors2.size());
        o2.setvar2("5");
        o2.setVar2("-1");
        errors2 = this.validator.validate((Object)o2, new Class[0]);
        ValidationTest.assertEquals((int)1, (int)errors2.size());
    }

    public void testAccessStrategies_on_children() {
        AccessTestBusinessObject o1 = new AccessTestBusinessObject("1");
        AccessTestBusinessObject o2 = new AccessTestBusinessObject("2");
        o1.next(o2);
        Set errors = this.validator.validate((Object)o1, new Class[0]);
        ValidationTest.assertEquals((int)1, (int)errors.size());
        o2 = new AccessTestBusinessObject("1");
        o1.next(o2);
        errors = this.validator.validate((Object)o1, new Class[0]);
        ValidationTest.assertEquals((int)0, (int)errors.size());
        o1.setToBeIgnored(new AccessTestBusinessObject("99"));
        errors = this.validator.validate((Object)o1, new Class[0]);
        ValidationTest.assertEquals((int)0, (int)errors.size());
        o1.setNext(new AccessTestBusinessObject("99"));
        errors = this.validator.validate((Object)o1, new Class[0]);
        ValidationTest.assertEquals((int)1, (int)errors.size());
    }

    public void testBook() {
        Author author = new Author();
        author.setLastName("Baudelaire");
        author.setFirstName("");
        Book book = new Book();
        book.setAuthor(author);
        book.setSubtitle("12345678900125678901234578901234567890");
        Set errors = this.validator.validate((Object)book, new Class[]{Book.All.class});
        Assert.assertTrue((!errors.isEmpty() ? 1 : 0) != 0);
        book.setTitle("Les fleurs du mal");
        author.setCompany("Some random publisher with a very very very long name");
    }

    public void testValidAnnotation() {
        Author a = new Author();
        a.setAddresses(new ArrayList<Address>());
        BusinessAddress adr = new BusinessAddress();
        adr.setCountry(new Country());
        adr.setAddressline1("line1");
        adr.setAddressline2("line2");
        adr.setZipCode("1234567890123456789");
        a.getAddresses().add(adr);
        a.setFirstName("Karl");
        a.setLastName("May");
        Set found = this.validator.validate((Object)a, new Class[]{Default.class, First.class, Last.class});
        Assert.assertTrue((!found.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((int)4, (int)found.size());
        adr.setCity("Berlin");
        adr.setZipCode("12345");
        adr.setCompany("apache");
        found = this.validator.validate((Object)a, new Class[]{Default.class, First.class, Last.class});
        Assert.assertEquals((int)1, (int)found.size());
        ConstraintViolation ic = (ConstraintViolation)found.iterator().next();
        Assert.assertEquals((String)"addresses[0].country.name", (String)ic.getPropertyPath().toString());
    }

    public void testPropertyPathWithIndex() {
        Author a = new Author();
        a.setAddresses(new ArrayList<Address>());
        Address adr = new Address();
        adr.setAddressline1("adr1");
        adr.setCity("Santiago");
        a.getAddresses().add(adr);
        adr = new Address();
        adr.setAddressline1("adr2");
        adr.setCity("Havanna");
        a.getAddresses().add(adr);
        adr = new Address();
        adr.setAddressline1("adr3");
        adr.setCity("Trinidad");
        a.getAddresses().add(adr);
        Set constraints = this.validator.validate((Object)a, new Class[0]);
        Assert.assertTrue((!constraints.isEmpty() ? 1 : 0) != 0);
        this.assertPropertyPath("addresses[0].country", constraints);
        this.assertPropertyPath("addresses[1].country", constraints);
        this.assertPropertyPath("addresses[2].country", constraints);
    }

    public void testPropertyPathOnSet() {
        Continent c = new Continent();
        c.name = "c1";
        Country country = new Country();
        country.setISO2Code("xx");
        country.setISO3Code("xxx");
        country.setName(null);
        c.countries.add(country);
        Set constraints = this.validator.validate((Object)c, new Class[0]);
        Assert.assertEquals((String)"Incorrect number of violations detected", (int)1, (int)constraints.size());
        this.assertPropertyPath("countries[].name", constraints);
    }

    private <T> void assertPropertyPath(String propertyPath, Set<ConstraintViolation<T>> constraints) {
        for (ConstraintViolation<T> each : constraints) {
            if (!each.getPropertyPath().toString().equals(propertyPath)) continue;
            return;
        }
        Assert.fail((String)(propertyPath + " not found in " + constraints));
    }

    public void testPropertyPathRecursive() {
        RecursiveFoo foo1 = new RecursiveFoo();
        RecursiveFoo foo11 = new RecursiveFoo();
        foo1.getFoos().add(foo11);
        RecursiveFoo foo12 = new RecursiveFoo();
        foo1.getFoos().add(foo12);
        RecursiveFoo foo2 = new RecursiveFoo();
        foo11.getFoos().add(foo2);
        Set constraints = this.validator.validate((Object)foo1, new Class[0]);
        this.assertPropertyPath("foos[0].foos[0].foos", constraints);
        this.assertPropertyPath("foos[1].foos", constraints);
    }

    public void testNullElementInCollection() {
        try {
            this.validator.validate(null, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        RecursiveFoo foo = new RecursiveFoo();
        foo.getFoos().add(new RecursiveFoo());
        foo.getFoos().add(null);
        Assert.assertTrue((!this.validator.validate((Object)foo, new Class[0]).isEmpty() ? 1 : 0) != 0);
    }

    public void testGroups() {
        Author author = new Author();
        author.setCompany("ACME");
        Book book = new Book();
        book.setTitle("");
        book.setAuthor(author);
        boolean foundTitleConstraint = false;
        Set constraintViolations = this.validator.validate((Object)book, new Class[]{Book.All.class});
        ValidationTest.assertEquals((int)1, (int)constraintViolations.size());
        for (ConstraintViolation constraintViolation : constraintViolations) {
            if (((Book)constraintViolation.getRootBean()).getClass() != Book.class) continue;
            Assert.assertEquals((String)"may not be empty", (String)constraintViolation.getMessage());
            Assert.assertTrue((book == constraintViolation.getRootBean() ? 1 : 0) != 0);
            if (!constraintViolation.getPropertyPath().toString().equals("title")) continue;
            foundTitleConstraint = true;
            Assert.assertEquals((Object)book.getTitle(), (Object)constraintViolation.getInvalidValue());
        }
        Assert.assertTrue((boolean)foundTitleConstraint);
    }

    public void testConstraintValidatorContextFluentAPI() {
        Address ad = new Address();
        ad.setCity("error");
        ad.setZipCode("error");
        ad.setAddressline1("something");
        ad.setCountry(new Country());
        ad.getCountry().setName("something");
        Set violations = this.validator.validate((Object)ad, new Class[0]);
        Assert.assertEquals((int)2, (int)violations.size());
        for (ConstraintViolation each : violations) {
            Assert.assertTrue((boolean)each.getMessage().endsWith(" not OK"));
        }
        ValidationTest.assertNotNull(TestUtils.getViolation(violations, "city"));
        ValidationTest.assertNotNull(TestUtils.getViolation(violations, ""));
    }

    public void testValidateNestedPropertyPath() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String propPath = "addresses[0].country.ISO2Code";
        Author author = new Author();
        author.setAddresses(new ArrayList<Address>());
        Address adr = new Address();
        author.getAddresses().add(adr);
        Country country = new Country();
        adr.setCountry(country);
        country.setISO2Code("too_long");
        Set iv = this.validator.validateProperty((Object)author, "addresses[0].country.ISO2Code", new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        ConstraintViolation vio = (ConstraintViolation)iv.iterator().next();
        ValidationTest.assertEquals((String)"addresses[0].country.ISO2Code", (String)vio.getPropertyPath().toString());
        ValidationTest.assertSame((Object)author, (Object)vio.getRootBean());
        ValidationTest.assertSame((Object)author.getAddresses().get(0).getCountry(), (Object)vio.getLeafBean());
        country.setISO2Code("23");
        iv = this.validator.validateProperty((Object)author, "addresses[0].country.ISO2Code", new Class[0]);
        Assert.assertEquals((int)0, (int)iv.size());
        iv = this.validator.validateValue(Author.class, "addresses[0].country.ISO2Code", (Object)"345", new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        vio = (ConstraintViolation)iv.iterator().next();
        ValidationTest.assertEquals((String)"addresses[0].country.ISO2Code", (String)vio.getPropertyPath().toString());
        ValidationTest.assertNull((Object)vio.getRootBean());
        ValidationTest.assertNull((Object)vio.getLeafBean());
        iv = this.validator.validateValue(Author.class, "addresses[0].country.ISO2Code", (Object)"34", new Class[0]);
        Assert.assertEquals((int)0, (int)iv.size());
    }

    public void testValidateCascadingNestedBean() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String propPath = "addresses[0]";
        CascadingPropertyValidator v = (CascadingPropertyValidator)this.validator.unwrap(CascadingPropertyValidator.class);
        Author author = new Author();
        author.setAddresses(new ArrayList<Address>());
        Address adr = new Address();
        author.getAddresses().add(adr);
        Country country = new Country();
        adr.setCity("dark");
        adr.setCountry(country);
        Set iv = v.validateProperty((Object)author, "addresses[0]", new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        country.setISO2Code("too_long");
        iv = v.validateProperty((Object)author, "addresses[0]", true, new Class[0]);
        Assert.assertEquals((int)3, (int)iv.size());
        country.setISO2Code("23");
        iv = v.validateProperty((Object)author, "addresses[0]", true, new Class[0]);
        Assert.assertEquals((int)2, (int)iv.size());
        Address value = new Address();
        value.setCity("whatever");
        value.setAddressline1("1 address line");
        iv = v.validateValue(Author.class, "addresses[0]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        value.setCountry(new Country());
        iv = v.validateValue(Author.class, "addresses[0]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        value.getCountry().setName("NWO");
        iv = v.validateValue(Author.class, "addresses[0]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)0, (int)iv.size());
    }

    public void testValidateCascadingNestedProperty() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String propPath = "addresses[0].country";
        CascadingPropertyValidator v = (CascadingPropertyValidator)this.validator.unwrap(CascadingPropertyValidator.class);
        Author author = new Author();
        author.setAddresses(new ArrayList<Address>());
        Address adr = new Address();
        author.getAddresses().add(adr);
        Country country = new Country();
        adr.setCity("dark");
        adr.setCountry(country);
        Set iv = v.validateProperty((Object)author, "addresses[0].country", new Class[0]);
        Assert.assertEquals((int)0, (int)iv.size());
        country.setISO2Code("too_long");
        iv = v.validateProperty((Object)author, "addresses[0].country", true, new Class[0]);
        Assert.assertEquals((int)2, (int)iv.size());
        country.setISO2Code("23");
        iv = v.validateProperty((Object)author, "addresses[0].country", true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        Country value = null;
        iv = v.validateValue(Author.class, "addresses[0].country", value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        value = new Country();
        iv = v.validateValue(Author.class, "addresses[0].country", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        value.setName("NWO");
        iv = v.validateValue(Author.class, "addresses[0].country", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)0, (int)iv.size());
    }

    public void testValidateCascadingNestedTipProperty() {
        String propPath = "addresses[0].country.name";
        CascadingPropertyValidator v = (CascadingPropertyValidator)this.validator.unwrap(CascadingPropertyValidator.class);
        Author author = new Author();
        author.setAddresses(new ArrayList<Address>());
        Address adr = new Address();
        author.getAddresses().add(adr);
        Country country = new Country();
        adr.setCity("dark");
        adr.setCountry(country);
        Set iv = v.validateProperty((Object)author, "addresses[0].country.name", new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        iv = v.validateProperty((Object)author, "addresses[0].country.name", true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
    }

    public void testValidateCascadingKeyedElement() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String propPath = "[foo]";
        CascadingPropertyValidator v = (CascadingPropertyValidator)this.validator.unwrap(CascadingPropertyValidator.class);
        final Address adr = new Address();
        HashMap<String, Address> map = new HashMap<String, Address>(){
            {
                this.put("foo", adr);
            }
        };
        Country country = new Country();
        adr.setCity("dark");
        adr.setCountry(country);
        Set iv = v.validateProperty((Object)map, "[foo]", new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        country.setISO2Code("too_long");
        iv = v.validateProperty((Object)map, "[foo]", true, new Class[0]);
        Assert.assertEquals((int)3, (int)iv.size());
        country.setISO2Code("23");
        iv = v.validateProperty((Object)map, "[foo]", true, new Class[0]);
        Assert.assertEquals((int)2, (int)iv.size());
        Address value = new Address();
        value.setCity("whatever");
        value.setAddressline1("1 address line");
        Set iv2 = v.validateValue(map.getClass(), "[foo]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv2.size());
        value.setCountry(new Country());
        iv2 = v.validateValue(map.getClass(), "[foo]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv2.size());
        value.getCountry().setName("NWO");
        iv2 = v.validateValue(map.getClass(), "[foo]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)0, (int)iv2.size());
    }

    public void testValidateCascadingKeyedGenericElement() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String propPath = "[foo]";
        CascadingPropertyValidator v = (CascadingPropertyValidator)this.validator.unwrap(CascadingPropertyValidator.class);
        Address adr = new Address();
        HashMap map = new HashMap();
        ((Map)map).put("foo", adr);
        Country country = new Country();
        adr.setCity("dark");
        adr.setCountry(country);
        Set iv = v.validateProperty(map, "[foo]", new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        country.setISO2Code("too_long");
        iv = v.validateProperty(map, "[foo]", true, new Class[0]);
        Assert.assertEquals((int)3, (int)iv.size());
        country.setISO2Code("23");
        iv = v.validateProperty(map, "[foo]", true, new Class[0]);
        Assert.assertEquals((int)2, (int)iv.size());
        Address value = new Address();
        value.setCity("whatever");
        value.setAddressline1("1 address line");
        Set iv2 = v.validateValue(Map.class, "[foo]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv2.size());
        value.setCountry(new Country());
        iv2 = v.validateValue(Map.class, "[foo]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv2.size());
        value.getCountry().setName("NWO");
        iv2 = v.validateValue(Map.class, "[foo]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)0, (int)iv2.size());
    }

    public void testValidateCascadingIndexedElement() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String propPath = "[0]";
        CascadingPropertyValidator v = (CascadingPropertyValidator)this.validator.unwrap(CascadingPropertyValidator.class);
        Address value = new Address();
        value.setCity("whatever");
        value.setAddressline1("1 address line");
        Address[] array = new Address[]{value};
        Set iv = v.validateProperty((Object)array, "[0]", true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        value.setCountry(new Country());
        iv = v.validateProperty((Object)array, "[0]", true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        value.getCountry().setName("NWO");
        iv = v.validateProperty((Object)array, "[0]", true, new Class[0]);
        Assert.assertEquals((int)0, (int)iv.size());
        value = new Address();
        value.setCity("whatever");
        value.setAddressline1("1 address line");
        Set iv2 = v.validateValue(array.getClass(), "[0]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv2.size());
        value.setCountry(new Country());
        iv2 = v.validateValue(array.getClass(), "[0]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv2.size());
        value.getCountry().setName("NWO");
        iv2 = v.validateValue(array.getClass(), "[0]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)0, (int)iv2.size());
    }

    public void testValidateCascadingIndexedGenericElement() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String propPath = "[0]";
        CascadingPropertyValidator v = (CascadingPropertyValidator)this.validator.unwrap(CascadingPropertyValidator.class);
        Address value = new Address();
        value.setCity("whatever");
        value.setAddressline1("1 address line");
        List<Address> list = Collections.singletonList(value);
        Set iv = v.validateProperty(list, "[0]", true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        value.setCountry(new Country());
        iv = v.validateProperty(list, "[0]", true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        value.getCountry().setName("NWO");
        iv = v.validateProperty(list, "[0]", true, new Class[0]);
        Assert.assertEquals((int)0, (int)iv.size());
        value = new Address();
        value.setCity("whatever");
        value.setAddressline1("1 address line");
        Set iv2 = v.validateValue(List.class, "[0]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv2.size());
        value.setCountry(new Country());
        iv2 = v.validateValue(List.class, "[0]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)1, (int)iv2.size());
        value.getCountry().setName("NWO");
        iv2 = v.validateValue(List.class, "[0]", (Object)value, true, new Class[0]);
        Assert.assertEquals((int)0, (int)iv2.size());
    }

    public void testValidateCascadingPropertyWithMultipleGroupsIgnoresSiblingProperties() {
        String propPath = "addresses[0].country";
        CascadingPropertyValidator v = (CascadingPropertyValidator)this.validator.unwrap(CascadingPropertyValidator.class);
        Author author = new Author();
        author.setAddresses(new ArrayList<Address>());
        FooAddress adr = new FooAddress();
        author.getAddresses().add(adr);
        Country country = new Country();
        adr.setCountry(country);
        Set iv = v.validateProperty((Object)author, "addresses[0].country", true, new Class[]{Default.class, Foo.class});
        Assert.assertEquals((int)1, (int)iv.size());
    }

    public void testMetadataAPI() {
        BeanDescriptor bookBeanDescriptor = this.validator.getConstraintsForClass(Book.class);
        Assert.assertFalse((boolean)bookBeanDescriptor.hasConstraints());
        Assert.assertTrue((boolean)bookBeanDescriptor.isBeanConstrained());
        Assert.assertTrue((bookBeanDescriptor.getConstraintDescriptors().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)4, (int)bookBeanDescriptor.getConstrainedProperties().size());
        Assert.assertTrue((bookBeanDescriptor.getConstraintsForProperty("doesNotExist") == null ? 1 : 0) != 0);
        Assert.assertTrue((bookBeanDescriptor.getConstraintsForProperty("description") == null ? 1 : 0) != 0);
        PropertyDescriptor propertyDescriptor = bookBeanDescriptor.getConstraintsForProperty("title");
        Assert.assertEquals((int)2, (int)propertyDescriptor.getConstraintDescriptors().size());
        Assert.assertTrue((boolean)"title".equals(propertyDescriptor.getPropertyName()));
        Iterator iter = propertyDescriptor.getConstraintDescriptors().iterator();
        ConstraintDescriptor constraintDescriptor = null;
        while (iter.hasNext() && !(constraintDescriptor = (ConstraintDescriptor)iter.next()).getAnnotation().annotationType().equals(NotNull.class)) {
        }
        Assert.assertTrue((constraintDescriptor != null ? 1 : 0) != 0);
        Assert.assertTrue((constraintDescriptor.getGroups().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals(NotNullValidator.class, constraintDescriptor.getConstraintValidatorClasses().get(0));
        propertyDescriptor = bookBeanDescriptor.getConstraintsForProperty("subtitle");
        Iterator iterator = propertyDescriptor.getConstraintDescriptors().iterator();
        constraintDescriptor = (ConstraintDescriptor)iterator.next();
        Assert.assertTrue((boolean)constraintDescriptor.getAnnotation().annotationType().equals(Size.class));
        Assert.assertTrue(((Integer)constraintDescriptor.getAttributes().get("max") == 30 ? 1 : 0) != 0);
        Assert.assertTrue((constraintDescriptor.getGroups().size() == 1 ? 1 : 0) != 0);
        propertyDescriptor = bookBeanDescriptor.getConstraintsForProperty("author");
        Assert.assertTrue((propertyDescriptor.getConstraintDescriptors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)propertyDescriptor.isCascaded());
        Assert.assertNull((Object)bookBeanDescriptor.getConstraintsForProperty("unconstraintField"));
    }

    public void testKeyedMetadata() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(new HashMap<String, Object>(){}.getClass());
        Assert.assertNotNull((Object)beanDescriptor);
        Assert.assertFalse((boolean)beanDescriptor.isBeanConstrained());
        Assert.assertNull((Object)beanDescriptor.getConstraintsForProperty("[foo]"));
    }

    public void testGenericKeyedMetadata() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Map.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Assert.assertFalse((boolean)beanDescriptor.isBeanConstrained());
        Assert.assertNull((Object)beanDescriptor.getConstraintsForProperty("[foo]"));
    }

    public void testIndexedMetadata() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Array.newInstance(Author.class, 0).getClass());
        Assert.assertNotNull((Object)beanDescriptor);
        Assert.assertFalse((boolean)beanDescriptor.isBeanConstrained());
        Assert.assertNull((Object)beanDescriptor.getConstraintsForProperty("[0]"));
    }

    public void testGenericIndexedMetadata() {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(List.class);
        Assert.assertNotNull((Object)beanDescriptor);
        Assert.assertFalse((boolean)beanDescriptor.isBeanConstrained());
        Assert.assertNull((Object)beanDescriptor.getConstraintsForProperty("[0]"));
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    public static class FooAddress
    extends Address {
        @NotNull(groups={Foo.class})
        public String getCity() {
            return super.getCity();
        }
    }

    public static interface Foo {
    }
}

