/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Pattern;
import junit.framework.TestCase;
import org.apache.bval.jsr303.DefaultMessageInterpolator;
import org.apache.bval.util.PropertyAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TckReproducerTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    protected Validator validator;

    public void setUp() throws Exception {
        super.setUp();
        this.validator = this.createValidator();
    }

    protected Validator createValidator() {
        return factory.getValidator();
    }

    public static <T> void assertCorrectNumberOfViolations(Set<ConstraintViolation<T>> violations, int expectedViolations) {
        TckReproducerTest.assertEquals((String)("Wrong number of constraint violations. Expected: " + expectedViolations + " Actual: " + violations.size()), (int)expectedViolations, (int)violations.size());
    }

    public void testPropertyAccessOnNonPublicClass() throws Exception {
        Car car = new Car("USd-298");
        TckReproducerTest.assertEquals((Object)car.getLicensePlateNumber(), (Object)PropertyAccess.getProperty((Object)car, (String)"licensePlateNumber"));
        Set violations = this.validator.validateProperty((Object)car, "licensePlateNumber", new Class[]{First.class, org.apache.bval.jsr303.example.Second.class});
        TckReproducerTest.assertCorrectNumberOfViolations(violations, 1);
        car.setLicensePlateNumber("USD-298");
        violations = this.validator.validateProperty((Object)car, "licensePlateNumber", new Class[]{First.class, org.apache.bval.jsr303.example.Second.class});
        TckReproducerTest.assertCorrectNumberOfViolations(violations, 0);
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    static interface Second {
    }

    static interface First {
    }

    class Car {
        @Pattern(regexp="[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]", groups={First.class, Second.class})
        private String licensePlateNumber;

        Car(String licensePlateNumber) {
            this.licensePlateNumber = licensePlateNumber;
        }

        public String getLicensePlateNumber() {
            return this.licensePlateNumber;
        }

        public void setLicensePlateNumber(String licensePlateNumber) {
            this.licensePlateNumber = licensePlateNumber;
        }
    }
}

