/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Payload;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import junit.framework.TestCase;
import org.apache.bval.jsr303.DefaultMessageInterpolator;
import org.apache.bval.jsr303.util.TestUtils;

public class PayloadTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    protected Validator validator;

    public void setUp() throws Exception {
        super.setUp();
        this.validator = this.createValidator();
    }

    protected Validator createValidator() {
        return factory.getValidator();
    }

    public void testPayload() {
        Address address = new Address(null, null);
        Set violations = this.validator.validate((Object)address, new Class[0]);
        PayloadTest.assertEquals((int)2, (int)violations.size());
        ConstraintViolation vio = TestUtils.getViolation(violations, "zipCode");
        PayloadTest.assertNotNull(vio);
        PayloadTest.assertEquals((int)1, (int)vio.getConstraintDescriptor().getPayload().size());
        PayloadTest.assertTrue((boolean)vio.getConstraintDescriptor().getPayload().contains(Severity.Info.class));
        vio = TestUtils.getViolation(violations, "city");
        PayloadTest.assertNotNull(vio);
        PayloadTest.assertEquals((int)1, (int)vio.getConstraintDescriptor().getPayload().size());
        PayloadTest.assertTrue((boolean)vio.getConstraintDescriptor().getPayload().contains(Severity.Error.class));
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    static class Address {
        private String zipCode;
        private String city;

        Address(String zipCode, String city) {
            this.zipCode = zipCode;
            this.city = city;
        }

        @NotNull(message="would be nice if we had one", payload={Severity.Info.class})
        public String getZipCode() {
            return this.zipCode;
        }

        @NotNull(message="the city is mandatory", payload={Severity.Error.class})
        public String getCity() {
            return this.city;
        }
    }

    static class Severity {
        Severity() {
        }

        static class Error
        implements Payload {
            Error() {
            }
        }

        static class Info
        implements Payload {
            Info() {
            }
        }
    }
}

