/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.validation.UnexpectedTypeException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.constraints.SizeValidatorForString;
import org.apache.bval.jsr303.DefaultMessageInterpolator;
import org.apache.bval.jsr303.example.Address;
import org.apache.bval.jsr303.example.Book;
import org.apache.bval.jsr303.example.Engine;
import org.apache.bval.jsr303.example.IllustratedBook;
import org.apache.bval.jsr303.example.MaxTestEntity;
import org.apache.bval.jsr303.example.NoValidatorTestEntity;
import org.apache.bval.jsr303.example.Second;
import org.apache.bval.jsr303.example.SizeTestEntity;
import org.apache.bval.jsr303.util.TestUtils;

public class Jsr303Test
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    protected Validator validator;

    public void setUp() throws Exception {
        super.setUp();
        this.validator = this.createValidator();
    }

    protected Validator createValidator() {
        return factory.getValidator();
    }

    public void testPropertyDescriptorHasConstraints() {
        BeanDescriptor cons = this.validator.getConstraintsForClass(Book.class);
        Jsr303Test.assertTrue((boolean)cons.getConstraintsForProperty("author").hasConstraints());
        Jsr303Test.assertTrue((boolean)cons.getConstraintsForProperty("title").hasConstraints());
        Jsr303Test.assertTrue((boolean)cons.getConstraintsForProperty("uselessField").hasConstraints());
        Jsr303Test.assertTrue((cons.getConstraintsForProperty("unconstraintField") == null || !cons.getConstraintsForProperty("unconstraintField").hasConstraints() ? 1 : 0) != 0);
        Jsr303Test.assertNull((Object)cons.getConstraintsForProperty("unknownField"));
    }

    public void testValidateValue() {
        Jsr303Test.assertTrue((boolean)this.validator.validateValue(Book.class, "subtitle", (Object)"123456789098765432", new Class[0]).isEmpty());
        Jsr303Test.assertFalse((boolean)this.validator.validateValue(Book.class, "subtitle", (Object)"123456789098765432123412345678909876543212341234564567890987654321234", new Class[]{Second.class}).isEmpty());
        Jsr303Test.assertEquals((int)0, (int)this.validator.validateValue(Book.class, "unconstraintField", (Object)4, new Class[0]).size());
        try {
            this.validator.validateValue(Book.class, "unknownProperty", (Object)4, new Class[0]);
            Jsr303Test.fail((String)"unknownProperty not detected");
        }
        catch (IllegalArgumentException ex) {
            Jsr303Test.assertEquals((String)"unknown property 'unknownProperty' in org.apache.bval.jsr303.example.Book", (String)ex.getMessage());
        }
    }

    public void testValidateNonCascadedRealNestedProperty() {
        try {
            this.validator.validateValue(IllustratedBook.class, "illustrator.firstName", (Object)"Edgar", new Class[0]);
            Jsr303Test.fail((String)"unknownProperty not detected");
        }
        catch (IllegalArgumentException ex) {
            Jsr303Test.assertEquals((String)"Property org.apache.bval.jsr303.example.IllustratedBook.illustrator is not cascaded", (String)ex.getMessage());
        }
    }

    public void testMetadataAPI_Book() {
        Assert.assertNotNull((Object)this.validator.getConstraintsForClass(Book.class));
        Assert.assertSame((Object)this.validator.getConstraintsForClass(Book.class), (Object)this.validator.getConstraintsForClass(Book.class));
        BeanDescriptor bc = this.validator.getConstraintsForClass(Book.class);
        Assert.assertEquals(Book.class, (Object)bc.getElementClass());
        Assert.assertTrue((bc.getConstraintDescriptors() != null ? 1 : 0) != 0);
        TestUtils.failOnModifiable(bc.getConstraintDescriptors(), "beanDescriptor constraintDescriptors");
    }

    public void testMetadataAPI_Engine() {
        PropertyDescriptor desc = this.validator.getConstraintsForClass(Engine.class).getConstraintsForProperty("serialNumber");
        Jsr303Test.assertNotNull((Object)desc);
        Assert.assertEquals(String.class, (Object)desc.getElementClass());
    }

    public void testMetadataAPI_Address() {
        Assert.assertFalse((boolean)this.validator.getConstraintsForClass(Address.class).getConstraintDescriptors().isEmpty());
        Set props = this.validator.getConstraintsForClass(Address.class).getConstrainedProperties();
        TestUtils.failOnModifiable(props, "beanDescriptor constrainedProperties");
        HashSet<String> propNames = new HashSet<String>(props.size());
        for (PropertyDescriptor each : props) {
            TestUtils.failOnModifiable(each.getConstraintDescriptors(), "propertyDescriptor constraintDescriptors");
            propNames.add(each.getPropertyName());
        }
        Assert.assertTrue((boolean)propNames.contains("addressline1"));
        Assert.assertTrue((boolean)propNames.contains("addressline2"));
        Assert.assertTrue((boolean)propNames.contains("zipCode"));
        Assert.assertTrue((boolean)propNames.contains("country"));
        Assert.assertTrue((boolean)propNames.contains("city"));
        Assert.assertEquals((int)5, (int)props.size());
        PropertyDescriptor desc = this.validator.getConstraintsForClass(Address.class).getConstraintsForProperty("addressline1");
        Assert.assertNotNull((Object)desc);
        boolean found = false;
        for (ConstraintDescriptor each : desc.getConstraintDescriptors()) {
            if (!((Class)each.getConstraintValidatorClasses().get(0)).equals(SizeValidatorForString.class)) continue;
            Assert.assertTrue((boolean)each.getAttributes().containsKey("max"));
            Jsr303Test.assertEquals((Object)30, each.getAttributes().get("max"));
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    public void testValidateMultiValuedConstraints() {
        Engine engine = new Engine();
        engine.serialNumber = "abcd-defg-0123";
        Set violations = this.validator.validate((Object)engine, new Class[0]);
        Jsr303Test.assertEquals((int)0, (int)violations.size());
        engine.serialNumber = "!)/(/()";
        violations = this.validator.validate((Object)engine, new Class[0]);
        Jsr303Test.assertEquals((int)2, (int)violations.size());
        for (String msg : new String[]{"must contain alphabetical characters only", "must match ....-....-...."}) {
            Jsr303Test.assertNotNull(TestUtils.getViolationWithMessage(violations, msg));
        }
    }

    public void testConstraintValidatorResolutionAlgorithm() {
        MaxTestEntity entity = new MaxTestEntity();
        entity.setText("101");
        entity.setProperty("201");
        entity.setLongValue(301L);
        entity.setDecimalValue(new BigDecimal(401));
        Set violations = this.validator.validate((Object)entity, new Class[0]);
        Jsr303Test.assertEquals((int)4, (int)violations.size());
        NoValidatorTestEntity entity2 = new NoValidatorTestEntity();
        try {
            this.validator.validate((Object)entity2, new Class[0]);
            Jsr303Test.fail((String)"UnexpectedTypeException expected but not thrown");
        }
        catch (UnexpectedTypeException ex) {
            Jsr303Test.assertEquals((String)"No validator could be found for type java.lang.Object. See: @Max at private java.lang.Object org.apache.bval.jsr303.example.NoValidatorTestEntity.anything", (String)ex.getMessage());
        }
    }

    public void testSizeValidation() {
        SizeTestEntity en = new SizeTestEntity();
        en.ba = new byte[3];
        en.ca = new char[3];
        en.boa = new boolean[3];
        en.coll = Arrays.asList("1", "2", "3");
        en.da = new double[3];
        en.fa = new float[3];
        en.it = new int[3];
        en.la = new long[3];
        en.map = new HashMap<String, String>();
        en.map.put("1", "1");
        en.map.put("3", "3");
        en.map.put("2", "2");
        en.oa = new Integer[3];
        en.oa2 = new Integer[3];
        en.sa = new short[3];
        en.text = "123";
        Set vi = this.validator.validate((Object)en, new Class[0]);
        Jsr303Test.assertEquals((int)13, (int)vi.size());
    }

    public void testGetConstraintsForNullClass() {
        try {
            this.validator.getConstraintsForClass(null);
            Assert.fail((String)"No exception thrown on Validator.getConstraintsForClass(null)");
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }
}

