/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.Locale;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.metadata.BeanDescriptor;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.jsr303.DefaultMessageInterpolator;

public class ExceptionsContractTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    protected Validator validator;

    public void setUp() throws Exception {
        super.setUp();
        this.validator = this.createValidator();
    }

    protected Validator createValidator() {
        return factory.getValidator();
    }

    public void testExceptionThrowingBean() {
        try {
            this.validator.validate((Object)new ExceptionThrowingBean(), new Class[0]);
            Assert.fail((String)"No exception thrown when validating a bean whose getter throws a RTE");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void testValidateNullGroup() {
        try {
            Class[] groups = null;
            this.validator.validate((Object)new String(), groups);
            Assert.fail((String)"No exception thrown when passing null as group array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateInvalidPropertyName() {
        try {
            this.validator.validateProperty((Object)new Person(), null, new Class[0]);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.validator.validateProperty((Object)new Person(), "", new Class[0]);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.validator.validateProperty((Object)new Person(), "surname", new Class[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidatePropertyOnNullBean() {
        try {
            this.validator.validateProperty(null, "class", new Class[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidatePropertyNullGroup() {
        try {
            Class[] groups = null;
            this.validator.validateProperty((Object)new Person(), "name", groups);
            Assert.fail((String)"No exception thrown when passing null as group array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateValueOnNullClass() {
        try {
            this.validator.validateValue(null, "class", Object.class, new Class[0]);
            Assert.fail((String)"No exception thrown when passing null as group array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateValueInvalidPropertyName() {
        try {
            this.validator.validateValue(Person.class, null, (Object)"John", new Class[0]);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.validator.validateValue(Person.class, "", (Object)"John", new Class[0]);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.validator.validateValue(Person.class, "unexistant", (Object)"John", new Class[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateValueNullGroup() {
        try {
            Class[] groups = null;
            this.validator.validateValue(Person.class, "name", (Object)"John", groups);
            Assert.fail((String)"No exception thrown when passing null as group array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateIncompatibleValue() {
        try {
            this.validator.validateValue(Person.class, "name", (Object)666, new Class[0]);
            Assert.fail((String)"No exception thrown when passing Integer for string value");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.validator.validateValue(Person.class, "age", null, new Class[0]);
            Assert.fail((String)"No exception thrown when passing null for primitive value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetConstraintsForInvalidProperty() {
        BeanDescriptor personDescriptor = this.validator.getConstraintsForClass(Person.class);
        try {
            personDescriptor.getConstraintsForProperty(null);
            ExceptionsContractTest.fail((String)"No exception thrown when calling getConstraintsForProperty with null property");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            personDescriptor.getConstraintsForProperty("");
            ExceptionsContractTest.fail((String)"No exception thrown when calling getConstraintsForProperty with empty property");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    public static class Person {
        @NotNull
        public String name;
        @Min(value=0L)
        public int age;
    }

    public static class ExceptionThrowingBean {
        @NotNull
        public String getValue() {
            throw new IllegalStateException();
        }
    }
}

