/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.Locale;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.constraints.Pattern;
import javax.validation.metadata.ConstraintDescriptor;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.DefaultMessageInterpolator;
import org.apache.bval.jsr303.example.Author;
import org.apache.bval.jsr303.example.PreferredGuest;

public class DefaultMessageInterpolatorTest
extends TestCase {
    private DefaultMessageInterpolator interpolator;

    public DefaultMessageInterpolatorTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(DefaultMessageInterpolatorTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.interpolator = new DefaultMessageInterpolator();
        this.interpolator.setLocale(Locale.ENGLISH);
    }

    public void testCreateResolver() {
        final Validator gvalidator = this.getValidator();
        DefaultMessageInterpolatorTest.assertTrue((!gvalidator.getConstraintsForClass(PreferredGuest.class).getConstraintsForProperty("guestCreditCardNumber").getConstraintDescriptors().isEmpty() ? 1 : 0) != 0);
        Object ctx = new MessageInterpolator.Context(){

            public ConstraintDescriptor<?> getConstraintDescriptor() {
                return (ConstraintDescriptor)gvalidator.getConstraintsForClass(PreferredGuest.class).getConstraintsForProperty("guestCreditCardNumber").getConstraintDescriptors().iterator().next();
            }

            public Object getValidatedValue() {
                return "12345678";
            }
        };
        String msg = this.interpolator.interpolate("{validator.creditcard}", ctx);
        Assert.assertEquals((String)"credit card is not valid", (String)msg);
        ctx = new MessageInterpolator.Context(){

            public ConstraintDescriptor<?> getConstraintDescriptor() {
                return (ConstraintDescriptor)gvalidator.getConstraintsForClass(Author.class).getConstraintsForProperty("lastName").getConstraintDescriptors().iterator().next();
            }

            public Object getValidatedValue() {
                return "";
            }
        };
        msg = this.interpolator.interpolate("{org.apache.bval.constraints.NotEmpty.message}", ctx);
        Assert.assertEquals((String)"may not be empty", (String)msg);
    }

    public void testReplacementWithSpecialChars() {
        final Validator validator = this.getValidator();
        Object ctx = new MessageInterpolator.Context(){

            public ConstraintDescriptor<?> getConstraintDescriptor() {
                return (ConstraintDescriptor)validator.getConstraintsForClass(Person.class).getConstraintsForProperty("idNumber").getConstraintDescriptors().iterator().next();
            }

            public Object getValidatedValue() {
                return "12345678";
            }
        };
        String result = this.interpolator.interpolate("Id number should match {regexp}", ctx);
        Assert.assertEquals((String)"Incorrect message interpolation when $ is in an attribute", (String)"Id number should match ....$", (String)result);
        ctx = new MessageInterpolator.Context(){

            public ConstraintDescriptor<?> getConstraintDescriptor() {
                return (ConstraintDescriptor)validator.getConstraintsForClass(Person.class).getConstraintsForProperty("otherId").getConstraintDescriptors().iterator().next();
            }

            public Object getValidatedValue() {
                return "12345678";
            }
        };
        result = this.interpolator.interpolate("Other id should match {regexp}", ctx);
        Assert.assertEquals((String)"Incorrect message interpolation when \\ is in an attribute value", (String)"Other id should match .\\n", (String)result);
    }

    private Validator getValidator() {
        return ApacheValidatorFactory.getDefault().getValidator();
    }

    public static class Person {
        @Pattern(message="Id number should match {regexp}", regexp="....$")
        public String idNumber;
        @Pattern(message="Other id should match {regexp}", regexp=".\\n")
        public String otherId;
    }
}

