/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ConfigurationState;
import junit.framework.TestCase;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.bval.jsr303.ApacheValidatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomValidatorFactoryTest
extends TestCase {
    public void testDefaultValidatorFactory() {
        ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().unwrap(ApacheValidatorFactory.class);
    }

    public void testNoSuchType() {
        try {
            ((ApacheValidatorConfiguration)((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).addProperty("apache.bval.validator-factory-classname", "no.such.type")).buildValidatorFactory();
            CustomValidatorFactoryTest.fail();
        }
        catch (ValidationException ex) {
            CustomValidatorFactoryTest.assertTrue((boolean)(ex.getCause() instanceof ClassNotFoundException));
        }
    }

    public void testCustomValidatorFactory() {
        this.doTest(CustomValidatorFactory.class, null);
    }

    public void testInvalidType() {
        this.doTest(NotAValidatorFactory.class, ClassCastException.class);
    }

    public void testUnsupportedValidatorFactoryType() {
        this.doTest(IncompatibleValidatorFactory.class, NoSuchMethodException.class);
    }

    private void doTest(Class<?> validatorFactoryType, Class<? extends Exception> expectedFailureCause) {
        try {
            ((ApacheValidatorConfiguration)((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).addProperty("apache.bval.validator-factory-classname", validatorFactoryType.getName())).buildValidatorFactory().unwrap(validatorFactoryType);
            CustomValidatorFactoryTest.assertNull(expectedFailureCause);
        }
        catch (ValidationException ex) {
            CustomValidatorFactoryTest.assertNotNull(expectedFailureCause);
            CustomValidatorFactoryTest.assertTrue((boolean)expectedFailureCause.isInstance(ex.getCause()));
        }
    }

    public static class NotAValidatorFactory {
        public NotAValidatorFactory(ConfigurationState configurationState) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncompatibleValidatorFactory
    implements ValidatorFactory {
        public ConstraintValidatorFactory getConstraintValidatorFactory() {
            return null;
        }

        public MessageInterpolator getMessageInterpolator() {
            return null;
        }

        public TraversableResolver getTraversableResolver() {
            return null;
        }

        public Validator getValidator() {
            return null;
        }

        public <T> T unwrap(Class<T> type) {
            return null;
        }

        public ValidatorContext usingContext() {
            return null;
        }
    }

    public static class CustomValidatorFactory
    extends ApacheValidatorFactory {
        public CustomValidatorFactory(ConfigurationState configurationState) {
            super(configurationState);
        }
    }
}

