/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import javax.validation.ConstraintValidatorContext;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.jsr303.ConstraintValidatorContextImpl;
import org.apache.bval.jsr303.GroupValidationContext;
import org.apache.bval.jsr303.util.PathImpl;
import org.apache.bval.model.ValidationListener;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ConstraintValidatorContextTest
extends TestCase {
    private ConstraintValidatorContextImpl cvc;
    private ConstraintValidatorContext.ConstraintViolationBuilder cvb;
    @Mock
    private GroupValidationContext<ValidationListener> groupValidationContext;

    public void setUp() throws Exception {
        super.setUp();
        MockitoAnnotations.initMocks((Object)((Object)this));
        Mockito.when((Object)this.groupValidationContext.getPropertyPath()).thenAnswer((Answer)new Answer<PathImpl>(){

            public PathImpl answer(InvocationOnMock invocation) throws Throwable {
                return PathImpl.createPathFromString((String)"");
            }
        });
        this.cvc = new ConstraintValidatorContextImpl(this.groupValidationContext, null);
        this.cvc.disableDefaultConstraintViolation();
        this.cvb = this.cvc.buildConstraintViolationWithTemplate("dummy.msg.tpl");
    }

    public void testPerson1() {
        this.cvb.addNode("person").addNode(null).inIterable().atIndex(Integer.valueOf(1)).addConstraintViolation();
        ValidationListener.Error error = (ValidationListener.Error)this.cvc.getErrorMessages().iterator().next();
        PathImpl errorPath = (PathImpl)error.getOwner();
        Assert.assertEquals((String)"Incorrect path created", (String)"person[1]", (String)errorPath.toString());
    }

    public void testPersonLawyerName() {
        this.cvb.addNode("person").addNode("name").inIterable().atKey((Object)"john").addConstraintViolation();
        ValidationListener.Error error = (ValidationListener.Error)this.cvc.getErrorMessages().iterator().next();
        PathImpl errorPath = (PathImpl)error.getOwner();
        Assert.assertEquals((String)"Incorrect path created", (String)"person[john].name", (String)errorPath.toString());
    }

    public void test0Name() {
        this.cvb.addNode(null).addNode("name").inIterable().atIndex(Integer.valueOf(0)).addNode(null).inIterable().addConstraintViolation();
        ValidationListener.Error error = (ValidationListener.Error)this.cvc.getErrorMessages().iterator().next();
        PathImpl errorPath = (PathImpl)error.getOwner();
        Assert.assertEquals((String)"Incorrect path created", (String)"[0].name[]", (String)errorPath.toString());
    }

    public void testEmptyIndex() {
        this.cvb.addNode(null).addNode(null).inIterable().addConstraintViolation();
        ValidationListener.Error error = (ValidationListener.Error)this.cvc.getErrorMessages().iterator().next();
        PathImpl errorPath = (PathImpl)error.getOwner();
        Assert.assertEquals((String)"Incorrect path created", (String)"[]", (String)errorPath.toString());
    }

    public void testRootPath() {
        this.cvb.addNode(null).addNode(null).addNode(null).addNode(null).addConstraintViolation();
        ValidationListener.Error error = (ValidationListener.Error)this.cvc.getErrorMessages().iterator().next();
        PathImpl errorPath = (PathImpl)error.getOwner();
        Assert.assertTrue((String)"Created path must be a root path", (boolean)errorPath.isRootPath());
    }
}

