/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintDefinitionException;
import javax.validation.Payload;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Min;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.constraints.NotNullValidator;
import org.apache.bval.jsr303.DefaultMessageInterpolator;

public class ConstraintDefinitionsTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    protected Validator validator;

    public void setUp() throws Exception {
        super.setUp();
        this.validator = this.createValidator();
    }

    protected Validator createValidator() {
        return factory.getValidator();
    }

    public void testCustomAttributes() {
        BeanDescriptor constraints = this.validator.getConstraintsForClass(Person.class);
        Set ageConstraints = constraints.getConstraintsForProperty("age").getConstraintDescriptors();
        Assert.assertEquals((String)"There should be 2 constraints in 'age'", (int)ageConstraints.size(), (int)2);
        for (ConstraintDescriptor cd : ageConstraints) {
            Assert.assertEquals((String)"Annotation should be @Min", (String)cd.getAnnotation().annotationType().getName(), (String)Min.class.getName());
        }
    }

    public void testNoGroupsConstraint() {
        try {
            this.validator.validate((Object)new NoGroups(), new Class[0]);
            ConstraintDefinitionsTest.fail((String)"No exception thrown when parsing a constraint definition with no groups() method");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    public void testInvalidDefaultGroupsConstraint() {
        try {
            this.validator.validate((Object)new InvalidGroups(), new Class[0]);
            ConstraintDefinitionsTest.fail((String)"No exception thrown when parsing a constraint definition with a groups() method does not return Class[]");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    public void testNoPayloadConstraint() {
        try {
            this.validator.validate((Object)new NoPayload(), new Class[0]);
            ConstraintDefinitionsTest.fail((String)"No exception thrown when parsing a constraint definition with no payload() method");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    public void testInvalidDefaultPayloadConstraint() {
        try {
            this.validator.validate((Object)new InvalidPayload(), new Class[0]);
            ConstraintDefinitionsTest.fail((String)"No exception thrown when parsing a constraint definition with a payload() method does not return an empty array");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    public void testNoMessageConstraint() {
        try {
            this.validator.validate((Object)new NoMessage(), new Class[0]);
            ConstraintDefinitionsTest.fail((String)"No exception thrown when parsing a constraint definition with no payload() method");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    public void testInvalidDefaultMessageConstraint() {
        try {
            this.validator.validate((Object)new InvalidMessage(), new Class[0]);
            ConstraintDefinitionsTest.fail((String)"No exception thrown when parsing a constraint definition with a message() method does not return a String");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    public void testInvalidAttributeConstraint() {
        try {
            this.validator.validate((Object)new InvalidAttribute(), new Class[0]);
            ConstraintDefinitionsTest.fail((String)"No exception thrown when parsing a constraint definition with a method starting with 'valid'");
        }
        catch (ConstraintDefinitionException constraintDefinitionException) {
            // empty catch block
        }
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Constraint(validatedBy={NotNullValidator.class})
    public static @interface InvalidAttributeConstraint {
        public String message() default "def msg";

        public String[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public String validValue() default "1";
    }

    public static class InvalidAttribute {
        @InvalidAttributeConstraint
        public String prop;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Constraint(validatedBy={NotNullValidator.class})
    public static @interface InvalidMessageConstraint {
        public int message();

        public String[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static class InvalidMessage {
        @InvalidMessageConstraint(message=2)
        public String prop;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Constraint(validatedBy={NotNullValidator.class})
    public static @interface NoMessageConstraint {
        public String[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static class NoMessage {
        @NoMessageConstraint
        public String prop;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Constraint(validatedBy={NotNullValidator.class})
    public static @interface InvalidPayloadConstraint {
        public String message() default "def msg";

        public String[] groups() default {};

        public Class<? extends Payload>[] payload() default {Payload1.class};

        public static class Payload1
        implements Payload {
        }
    }

    public static class InvalidPayload {
        @InvalidPayloadConstraint
        public String prop;
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Constraint(validatedBy={NotNullValidator.class})
    public static @interface NoPayloadConstraint {
        public String message() default "def msg";

        public String[] groups() default {};
    }

    public static class NoPayload {
        @NoPayloadConstraint
        public String prop;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Constraint(validatedBy={NotNullValidator.class})
    public static @interface InvalidGroupsConstraint {
        public String message() default "def msg";

        public String[] groups() default {"Group1"};

        public Class<? extends Payload>[] payload() default {};
    }

    public static class InvalidGroups {
        @InvalidGroupsConstraint
        public String prop;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Constraint(validatedBy={NotNullValidator.class})
    public static @interface NoGroupsConstraint {
        public String message() default "def msg";

        public Class<? extends Payload>[] payload() default {};
    }

    public static class NoGroups {
        @NoGroupsConstraint
        public String prop;
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface MinList {
        public Min[] value();
    }

    public static class Person {
        @MinList(value={@Min(value=20L), @Min(value=30L)})
        public Integer age;
    }
}

