/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Size;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.jsr303.DefaultMessageInterpolator;

public class CircularReferencesTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    protected Validator validator;

    public void setUp() throws Exception {
        super.setUp();
        this.validator = this.createValidator();
    }

    protected Validator createValidator() {
        return factory.getValidator();
    }

    public void testAutoreferringBean() {
        Person p1 = new Person();
        p1.name = "too-long-name";
        p1.sibling = p1;
        Set violations = this.validator.validate((Object)p1, new Class[0]);
        Assert.assertEquals((String)"Only 1 violation should be reported", (int)1, (int)violations.size());
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((String)"Incorrect violation path", (String)"name", (String)violation.getPropertyPath().toString());
    }

    public void testNonCircularArrayOfSameBean() {
        Boss boss = new Boss();
        Person p1 = new Person();
        p1.name = "too-long-name";
        boss.employees = new Person[]{p1, p1, p1, p1};
        Set violations = this.validator.validate((Object)boss, new Class[0]);
        Assert.assertEquals((String)"A total of 4 violations should be reported", (int)4, (int)violations.size());
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    public static class Boss {
        @Valid
        public Person[] employees;
    }

    public static class Person {
        @Valid
        public Person sibling;
        @Size(max=10)
        public String name;
    }
}

