/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import javax.validation.spi.ValidationProvider;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.constraints.NotNullValidator;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.ConfigurationImpl;
import org.apache.bval.jsr303.DefaultConstraintValidatorFactory;
import org.apache.bval.jsr303.DefaultMessageInterpolator;
import org.apache.bval.jsr303.example.Customer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapTest
extends TestCase {
    public void testDirectBootstrap() {
        Validator validator = ApacheValidatorFactory.getDefault().getValidator();
        Assert.assertNotNull((Object)validator);
        Assert.assertTrue((ApacheValidatorFactory.getDefault() == ApacheValidatorFactory.getDefault() ? 1 : 0) != 0);
    }

    public void testEverydayBootstrap() {
        ApacheValidatorFactory factory = (ApacheValidatorFactory)Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Assert.assertNotNull((Object)validator);
        ApacheValidatorFactory factory2 = (ApacheValidatorFactory)Validation.buildDefaultValidatorFactory();
        Assert.assertTrue((factory2 != factory ? 1 : 0) != 0);
        Assert.assertTrue((factory2.getMessageInterpolator() != factory.getMessageInterpolator() ? 1 : 0) != 0);
    }

    public void testLocalizedMessageInterpolatorFactory() {
        Configuration builder = Validation.byDefaultProvider().configure();
        DefaultMessageInterpolator interpolator = new DefaultMessageInterpolator();
        builder.messageInterpolator((MessageInterpolator)interpolator);
        ApacheValidatorFactory factory = (ApacheValidatorFactory)builder.buildValidatorFactory();
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    public void testCustomConstraintFactory() {
        Configuration builder = Validation.byDefaultProvider().configure();
        this.assertDefaultBuilderAndFactory(builder);
        ValidatorFactory factory = builder.buildValidatorFactory();
        Validator validator = factory.getValidator();
        Customer customer = new Customer();
        customer.setFirstName("John");
        Set ConstraintViolations = validator.validate((Object)customer, new Class[0]);
        Assert.assertFalse((boolean)ConstraintViolations.isEmpty());
        builder = Validation.byDefaultProvider().configure();
        builder.constraintValidatorFactory(new ConstraintValidatorFactory(){

            public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
                if (key == NotNullValidator.class) {
                    BadlyBehavedNotNullValidator result = new BadlyBehavedNotNullValidator();
                    return (T)((Object)result);
                }
                return (T)new DefaultConstraintValidatorFactory().getInstance(key);
            }
        });
        factory = builder.buildValidatorFactory();
        validator = factory.getValidator();
        Set ConstraintViolations2 = validator.validate((Object)customer, new Class[0]);
        Assert.assertTrue((String)"Wrong number of constraints", (ConstraintViolations.size() > ConstraintViolations2.size() ? 1 : 0) != 0);
    }

    public void testCustomResolverAndType() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                ArrayList list = new ArrayList(1);
                list.add((ValidationProvider<?>)new ApacheValidationProvider());
                return list;
            }
        };
        ApacheValidatorConfiguration builder = (ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).providerResolver(resolver).configure();
        this.assertDefaultBuilderAndFactory((Configuration<?>)builder);
    }

    public void testCustomResolver() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                return Collections.singletonList(new ApacheValidationProvider());
            }
        };
        Configuration builder = Validation.byDefaultProvider().providerResolver(resolver).configure();
        this.assertDefaultBuilderAndFactory(builder);
    }

    private void assertDefaultBuilderAndFactory(Configuration<?> builder) {
        Assert.assertNotNull(builder);
        Assert.assertTrue((boolean)(builder instanceof ConfigurationImpl));
        ValidatorFactory factory = builder.buildValidatorFactory();
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof ApacheValidatorFactory));
    }

    public void testFailingCustomResolver() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                return Collections.emptyList();
            }
        };
        ProviderSpecificBootstrap type = Validation.byProvider(ApacheValidationProvider.class);
        ProviderSpecificBootstrap specializedBuilderFactory = type.providerResolver(resolver);
        try {
            specializedBuilderFactory.configure();
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((String)"Wrong error message", (e.getMessage().contains("provider") && e.getMessage().contains("org.apache.bval.jsr303.ApacheValidationProvider") ? 1 : 0) != 0);
        }
    }

    class BadlyBehavedNotNullValidator
    extends NotNullValidator {
        BadlyBehavedNotNullValidator() {
        }

        public boolean isValid(Object object, ConstraintValidatorContext context) {
            return true;
        }
    }
}

