/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import java.math.BigDecimal;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.bval.constraints.DigitsValidatorForNumber;
import org.apache.bval.constraints.DigitsValidatorForString;

public class DigitsValidatorTest
extends TestCase {
    public DigitsValidatorTest(String name) {
        super(name);
    }

    public void testValidateNumber() {
        DigitsValidatorForNumber validator = new DigitsValidatorForNumber();
        validator.setFractional(4);
        validator.setIntegral(2);
        Assert.assertFalse((boolean)validator.isValid((Number)new BigDecimal("100.1234"), null));
        Assert.assertFalse((boolean)validator.isValid((Number)new BigDecimal("99.12345"), null));
        Assert.assertTrue((boolean)validator.isValid((Number)new BigDecimal("99.1234"), null));
        Assert.assertFalse((boolean)validator.isValid((Number)100.1234, null));
        Assert.assertFalse((boolean)validator.isValid((Number)99.12345, null));
        Assert.assertTrue((boolean)validator.isValid((Number)99.1234, null));
        Assert.assertTrue((boolean)validator.isValid((Number)99.1234, null));
        Assert.assertTrue((boolean)validator.isValid((Number)new BigDecimal("99.123400"), null));
    }

    public void testValidateString() {
        DigitsValidatorForString validator = new DigitsValidatorForString();
        validator.setFractional(4);
        validator.setIntegral(2);
        String val = "100.12345";
        Assert.assertFalse((boolean)validator.isValid(val, null));
        val = "99.1234";
        Assert.assertTrue((boolean)validator.isValid(val, null));
    }

    public void testValidateNumber2() {
        DigitsValidatorForNumber validator = new DigitsValidatorForNumber();
        validator.setFractional(4);
        validator.setIntegral(2);
        Long val = new Long("100");
        Assert.assertFalse((boolean)validator.isValid((Number)val, null));
        val = new Long("99");
        Assert.assertTrue((boolean)validator.isValid((Number)val, null));
    }

    public void testValidateString2() {
        DigitsValidatorForString validator = new DigitsValidatorForString();
        validator.setFractional(0);
        validator.setIntegral(2);
        String val = "99.5";
        Assert.assertFalse((boolean)validator.isValid(val, null));
        val = "99";
        Assert.assertTrue((boolean)validator.isValid(val, null));
    }

    public static Test suite() {
        return new TestSuite(DigitsValidatorTest.class);
    }
}

