/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.xml;

import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.bval.jsr303.ConfigurationImpl;
import org.apache.bval.jsr303.example.XmlEntitySampleBean;
import org.apache.bval.jsr303.resolver.SimpleTraversableResolver;
import org.apache.bval.jsr303.xml.TestConstraintValidatorFactory;
import org.apache.bval.jsr303.xml.TestMessageInterpolator;
import org.apache.bval.jsr303.xml.ValidationParser;

public class ValidationParserTest
extends TestCase
implements ApacheValidatorConfiguration.Properties {
    public ValidationParserTest(String name) {
        super(name);
    }

    public void testParse() {
        ValidationParser vp = new ValidationParser("sample-validation.xml");
        ConfigurationImpl config = new ConfigurationImpl(null, (ValidationProvider)new ApacheValidationProvider());
        vp.processValidationConfig(config);
    }

    public void testConfigureFromXml() {
        ValidatorFactory factory = this.getFactory();
        ValidationParserTest.assertTrue((boolean)(factory.getMessageInterpolator() instanceof TestMessageInterpolator));
        ValidationParserTest.assertTrue((boolean)(factory.getConstraintValidatorFactory() instanceof TestConstraintValidatorFactory));
        ValidationParserTest.assertTrue((boolean)(factory.getTraversableResolver() instanceof SimpleTraversableResolver));
        Validator validator = factory.getValidator();
        ValidationParserTest.assertNotNull((Object)validator);
    }

    private ValidatorFactory getFactory() {
        ApacheValidatorConfiguration config = (ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure();
        config.addProperty("apache.bval.validation-xml-path", "sample-validation.xml");
        return config.buildValidatorFactory();
    }

    public void testXmlEntitySample() {
        XmlEntitySampleBean bean = new XmlEntitySampleBean();
        bean.setFirstName("tooooooooooooooooooooooooooo long");
        bean.setValueCode("illegal");
        Validator validator = this.getFactory().getValidator();
        Set results = validator.validate((Object)bean, new Class[0]);
        ValidationParserTest.assertTrue((!results.isEmpty() ? 1 : 0) != 0);
        ValidationParserTest.assertTrue((results.size() == 3 ? 1 : 0) != 0);
        bean.setZipCode("123");
        bean.setValueCode("20");
        bean.setFirstName("valid");
        results = validator.validate((Object)bean, new Class[0]);
        ValidationParserTest.assertTrue((boolean)results.isEmpty());
    }

    public static Test suite() {
        return new TestSuite(ValidationParserTest.class);
    }
}

