/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.groups;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.validation.GroupDefinitionException;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.bval.jsr303.example.Address;
import org.apache.bval.jsr303.example.First;
import org.apache.bval.jsr303.example.Last;
import org.apache.bval.jsr303.example.Second;
import org.apache.bval.jsr303.groups.CyclicGroupSequence;
import org.apache.bval.jsr303.groups.CyclicGroupSequence1;
import org.apache.bval.jsr303.groups.Group;
import org.apache.bval.jsr303.groups.Groups;
import org.apache.bval.jsr303.groups.GroupsComputer;

public class GroupsComputerTest
extends TestCase {
    GroupsComputer groupsComputer;

    public GroupsComputerTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.groupsComputer = new GroupsComputer();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(GroupsComputerTest.class);
    }

    public void testComputeGroupsNotAnInterface() {
        HashSet<Class<String>> groups = new HashSet<Class<String>>();
        groups.add(String.class);
        try {
            this.groupsComputer.computeGroups(groups);
            GroupsComputerTest.fail();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void testGroupChainForNull() {
        try {
            this.groupsComputer.computeGroups((Class[])null);
            GroupsComputerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGroupChainForEmptySet() {
        try {
            this.groupsComputer.computeGroups(new HashSet());
            GroupsComputerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCyclicGroupSequences() {
        try {
            HashSet<Class<CyclicGroupSequence1>> groups = new HashSet<Class<CyclicGroupSequence1>>();
            groups.add(CyclicGroupSequence1.class);
            this.groupsComputer.computeGroups(groups);
            GroupsComputerTest.fail();
        }
        catch (GroupDefinitionException groupDefinitionException) {
            // empty catch block
        }
    }

    public void testCyclicGroupSequence() {
        try {
            HashSet<Class<CyclicGroupSequence>> groups = new HashSet<Class<CyclicGroupSequence>>();
            groups.add(CyclicGroupSequence.class);
            this.groupsComputer.computeGroups(groups);
            GroupsComputerTest.fail();
        }
        catch (GroupDefinitionException groupDefinitionException) {
            // empty catch block
        }
    }

    public void testGroupDuplicates() {
        HashSet<Class<First>> groups = new HashSet<Class<First>>();
        groups.add(First.class);
        groups.add(Second.class);
        groups.add(Last.class);
        Groups chain = this.groupsComputer.computeGroups(groups);
        GroupsComputerTest.assertEquals((int)3, (int)chain.groups.size());
        groups.clear();
        groups.add(First.class);
        groups.add(First.class);
        chain = this.groupsComputer.computeGroups(groups);
        GroupsComputerTest.assertEquals((int)1, (int)chain.groups.size());
        groups.clear();
        groups.add(First.class);
        groups.add(Last.class);
        groups.add(First.class);
        chain = this.groupsComputer.computeGroups(groups);
        GroupsComputerTest.assertEquals((int)2, (int)chain.groups.size());
    }

    public void testSequenceResolution() {
        HashSet<Class<Address.Complete>> groups = new HashSet<Class<Address.Complete>>();
        groups.add(Address.Complete.class);
        Groups chain = this.groupsComputer.computeGroups(groups);
        Iterator sequences = chain.getSequences().iterator();
        List sequence = (List)sequences.next();
        GroupsComputerTest.assertEquals(Default.class, (Object)((Group)sequence.get(0)).getGroup());
        GroupsComputerTest.assertEquals(Address.HighLevelCoherence.class, (Object)((Group)sequence.get(1)).getGroup());
    }
}

