/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.groups;

import java.util.ArrayList;
import java.util.Set;
import javax.validation.Validator;
import junit.framework.TestCase;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.example.Address;
import org.apache.bval.jsr303.example.Author;
import org.apache.bval.jsr303.example.Book;
import org.apache.bval.jsr303.example.Country;
import org.apache.bval.jsr303.example.Customer;
import org.apache.bval.jsr303.example.Employee;
import org.apache.bval.jsr303.example.Library;
import org.apache.bval.jsr303.example.Person;
import org.apache.bval.jsr303.util.TestUtils;

public class CollectionValidationTest
extends TestCase {
    private Validator validator;

    protected void setUp() {
        this.validator = ApacheValidatorFactory.getDefault().getValidator();
    }

    public void testValidateList() {
        Author author = new Author();
        author.setFirstName("Peter");
        author.setLastName("Ford");
        author.setCompany("IBM");
        author.setAddresses(new ArrayList<Address>());
        Address adr1 = new Address();
        adr1.setCountry(new Country());
        adr1.getCountry().setName("Germany");
        adr1.setCity("Bonn");
        adr1.setAddressline1("Strasse 1");
        Address adr2 = new Address();
        adr2.setCountry(new Country());
        adr2.getCountry().setName("Cuba");
        adr2.setCity("Habana");
        adr2.setAddressline1("Calle 2");
        Address adr3 = new Address();
        adr3.setCountry(new Country());
        adr3.getCountry().setName("USA");
        adr3.setCity("San Francisco");
        adr3.setAddressline1("Street 3");
        author.getAddresses().add(adr1);
        author.getAddresses().add(adr2);
        author.getAddresses().add(adr3);
        Set violations = this.validator.validate((Object)author, new Class[0]);
        CollectionValidationTest.assertEquals((int)0, (int)violations.size());
        adr2.setCity(null);
        adr3.setAddressline1(null);
        violations = this.validator.validate((Object)author, new Class[0]);
        CollectionValidationTest.assertEquals((int)2, (int)violations.size());
        CollectionValidationTest.assertNotNull((Object)TestUtils.getViolation(violations, "addresses[1].city"));
        CollectionValidationTest.assertNotNull((Object)TestUtils.getViolation(violations, "addresses[2].addressline1"));
    }

    public void testValidateMapAndRedefinedDefaultGroupOnNonRootBean() {
        Library lib = new Library();
        lib.setLibraryName("Leibnitz Bibliothek");
        Book book1 = new Book();
        book1.setTitle("History of time");
        book1.setSubtitle("How it really works");
        Author hawking = new Author();
        hawking.setFirstName("Stephen");
        hawking.setFirstName("Hawking");
        hawking.setAddresses(new ArrayList<Address>(1));
        Address adr = new Address();
        adr.setAddressline1("Street 1");
        adr.setCity("London");
        adr.setCountry(new Country());
        adr.getCountry().setName("England");
        hawking.getAddresses().add(adr);
        book1.setAuthor(hawking);
        Book book2 = new Book();
        Author castro = new Author();
        castro.setFirstName("Fidel");
        castro.setLastName("Castro Ruz");
        book2.setAuthor(castro);
        book2.setTitle("My life");
        Book book3 = new Book();
        book3.setTitle("World best jokes");
        Author someone = new Author();
        someone.setFirstName("John");
        someone.setLastName("Do");
        book3.setAuthor(someone);
        lib.getTaggedBooks().put("science", book1);
        lib.getTaggedBooks().put("politics", book2);
        lib.getTaggedBooks().put("humor", book3);
        Set violations = this.validator.validate((Object)lib, new Class[0]);
        CollectionValidationTest.assertTrue((boolean)violations.isEmpty());
        book2.setTitle(null);
        book3.getAuthor().setFirstName("");
        book1.getAuthor().getAddresses().get(0).setCity(null);
        violations = this.validator.validate((Object)lib, new Class[0]);
        CollectionValidationTest.assertEquals((String)"redefined default group of Book not correctly validated from Library", (int)3, (int)violations.size());
        CollectionValidationTest.assertNotNull((Object)TestUtils.getViolation(violations, "taggedBooks[politics].title"));
        CollectionValidationTest.assertNotNull((Object)TestUtils.getViolation(violations, "taggedBooks[humor].author.firstName"));
        CollectionValidationTest.assertNotNull((Object)TestUtils.getViolation(violations, "taggedBooks[science].author.addresses[0].city"));
    }

    public void testValidateArray() {
        Library lib = new Library();
        lib.setLibraryName("Unibibliothek");
        lib.setPersons(new Person[3]);
        lib.getPersons()[0] = new Employee("Marcel", "Reich-Ranicki");
        lib.getPersons()[1] = new Employee("Elke", "Heidenreich");
        lib.getPersons()[2] = new Customer();
        Set violations = this.validator.validate((Object)lib, new Class[0]);
        CollectionValidationTest.assertTrue((boolean)violations.isEmpty());
        ((Employee)lib.getPersons()[1]).setFirstName("");
        violations = this.validator.validate((Object)lib, new Class[0]);
        CollectionValidationTest.assertEquals((int)1, (int)violations.size());
        CollectionValidationTest.assertNotNull((Object)TestUtils.getViolation(violations, "employees[1].firstName"));
    }
}

