/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.example;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.bval.jsr303.example.Book;
import org.apache.bval.jsr303.example.Employee;
import org.apache.bval.jsr303.example.Person;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library {
    @NotNull
    private String libraryName;
    @Valid
    private final Map<String, Book> taggedBooks = new HashMap<String, Book>();
    private Person[] persons;

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public Map<String, Book> getTaggedBooks() {
        return this.taggedBooks;
    }

    public Person[] getPersons() {
        return this.persons;
    }

    public void setPersons(Person[] persons) {
        this.persons = persons;
    }

    @Valid
    public List<Employee> getEmployees() {
        if (this.persons == null) {
            return Collections.emptyList();
        }
        ArrayList<Employee> emps = new ArrayList<Employee>(this.persons.length);
        for (Person each : this.persons) {
            if (!(each instanceof Employee)) continue;
            emps.add((Employee)each);
        }
        return emps;
    }
}

