/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.constraints.NotNullValidator;
import org.apache.bval.jsr303.DefaultMessageInterpolator;
import org.apache.bval.jsr303.example.AccessTestBusinessObject;
import org.apache.bval.jsr303.example.AccessTestBusinessObjectSub;
import org.apache.bval.jsr303.example.Address;
import org.apache.bval.jsr303.example.Author;
import org.apache.bval.jsr303.example.Book;
import org.apache.bval.jsr303.example.BusinessAddress;
import org.apache.bval.jsr303.example.Continent;
import org.apache.bval.jsr303.example.Country;
import org.apache.bval.jsr303.example.First;
import org.apache.bval.jsr303.example.Last;
import org.apache.bval.jsr303.example.RecursiveFoo;
import org.apache.bval.jsr303.util.TestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    private Validator getValidator() {
        return factory.getValidator();
    }

    public void testAccessStrategies_field_method() {
        AccessTestBusinessObject o1 = new AccessTestBusinessObject("1");
        AccessTestBusinessObjectSub o2 = new AccessTestBusinessObjectSub("3");
        Validator validator = this.getValidator();
        Set errors = validator.validate((Object)o1, new Class[0]);
        ValidationTest.assertTrue((boolean)errors.isEmpty());
        Set errors2 = validator.validate((Object)o2, new Class[0]);
        ValidationTest.assertTrue((boolean)errors2.isEmpty());
        o2 = new AccessTestBusinessObjectSub("1");
        errors2 = validator.validate((Object)o2, new Class[0]);
        ValidationTest.assertEquals((int)1, (int)errors2.size());
        o2 = new AccessTestBusinessObjectSub("3");
        o2.setVar2("1");
        o2.setvar2("2");
        errors2 = validator.validate((Object)o2, new Class[0]);
        ValidationTest.assertEquals((int)2, (int)errors2.size());
        o2.setvar2("5");
        o2.setVar2("6");
        errors2 = validator.validate((Object)o2, new Class[0]);
        ValidationTest.assertEquals((int)0, (int)errors2.size());
        o2.setvar2("5");
        o2.setVar2("-1");
        errors2 = validator.validate((Object)o2, new Class[0]);
        ValidationTest.assertEquals((int)1, (int)errors2.size());
    }

    public void testAccessStrategies_on_children() {
        AccessTestBusinessObject o1 = new AccessTestBusinessObject("1");
        AccessTestBusinessObject o2 = new AccessTestBusinessObject("2");
        o1.next(o2);
        Validator validator = this.getValidator();
        Set errors = validator.validate((Object)o1, new Class[0]);
        ValidationTest.assertEquals((int)1, (int)errors.size());
        o2 = new AccessTestBusinessObject("1");
        o1.next(o2);
        errors = validator.validate((Object)o1, new Class[0]);
        ValidationTest.assertEquals((int)0, (int)errors.size());
        o1.setToBeIgnored(new AccessTestBusinessObject("99"));
        errors = validator.validate((Object)o1, new Class[0]);
        ValidationTest.assertEquals((int)0, (int)errors.size());
        o1.setNext(new AccessTestBusinessObject("99"));
        errors = validator.validate((Object)o1, new Class[0]);
        ValidationTest.assertEquals((int)1, (int)errors.size());
    }

    public void testBook() {
        Validator validator = this.getValidator();
        Author author = new Author();
        author.setLastName("Baudelaire");
        author.setFirstName("");
        Book book = new Book();
        book.setAuthor(author);
        book.setSubtitle("12345678900125678901234578901234567890");
        Set errors = validator.validate((Object)book, new Class[]{Book.All.class});
        Assert.assertTrue((!errors.isEmpty() ? 1 : 0) != 0);
        book.setTitle("Les fleurs du mal");
        author.setCompany("Some random publisher with a very very very long name");
    }

    public void testValidAnnotation() {
        Author a = new Author();
        a.setAddresses(new ArrayList<Address>());
        BusinessAddress adr = new BusinessAddress();
        adr.setCountry(new Country());
        adr.setAddressline1("line1");
        adr.setAddressline2("line2");
        adr.setZipCode("1234567890123456789");
        a.getAddresses().add(adr);
        a.setFirstName("Karl");
        a.setLastName("May");
        Validator v = this.getValidator();
        Set found = v.validate((Object)a, new Class[]{Default.class, First.class, Last.class});
        Assert.assertTrue((!found.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((int)4, (int)found.size());
        adr.setCity("Berlin");
        adr.setZipCode("12345");
        adr.setCompany("apache");
        found = v.validate((Object)a, new Class[]{Default.class, First.class, Last.class});
        Assert.assertEquals((int)1, (int)found.size());
        ConstraintViolation ic = (ConstraintViolation)found.iterator().next();
        Assert.assertEquals((String)"addresses[0].country.name", (String)ic.getPropertyPath().toString());
    }

    public void testPropertyPathWithIndex() {
        Author a = new Author();
        a.setAddresses(new ArrayList<Address>());
        Address adr = new Address();
        adr.setAddressline1("adr1");
        adr.setCity("Santiago");
        a.getAddresses().add(adr);
        adr = new Address();
        adr.setAddressline1("adr2");
        adr.setCity("Havanna");
        a.getAddresses().add(adr);
        adr = new Address();
        adr.setAddressline1("adr3");
        adr.setCity("Trinidad");
        a.getAddresses().add(adr);
        Set constraints = this.getValidator().validate((Object)a, new Class[0]);
        Assert.assertTrue((!constraints.isEmpty() ? 1 : 0) != 0);
        this.assertPropertyPath("addresses[0].country", constraints);
        this.assertPropertyPath("addresses[1].country", constraints);
        this.assertPropertyPath("addresses[2].country", constraints);
    }

    public void testPropertyPathOnSet() {
        Continent c = new Continent();
        c.name = "c1";
        Country country = new Country();
        country.setISO2Code("xx");
        country.setISO3Code("xxx");
        country.setName(null);
        c.countries.add(country);
        Set constraints = this.getValidator().validate((Object)c, new Class[0]);
        Assert.assertEquals((String)"Incorrect number of violations detected", (int)1, (int)constraints.size());
        this.assertPropertyPath("countries[].name", constraints);
    }

    private <T> void assertPropertyPath(String propertyPath, Set<ConstraintViolation<T>> constraints) {
        for (ConstraintViolation<T> each : constraints) {
            if (!each.getPropertyPath().toString().equals(propertyPath)) continue;
            return;
        }
        Assert.fail((String)(propertyPath + " not found in " + constraints));
    }

    public void testPropertyPathRecursive() {
        RecursiveFoo foo1 = new RecursiveFoo();
        RecursiveFoo foo11 = new RecursiveFoo();
        foo1.getFoos().add(foo11);
        RecursiveFoo foo12 = new RecursiveFoo();
        foo1.getFoos().add(foo12);
        RecursiveFoo foo2 = new RecursiveFoo();
        foo11.getFoos().add(foo2);
        Set constraints = this.getValidator().validate((Object)foo1, new Class[0]);
        this.assertPropertyPath("foos[0].foos[0].foos", constraints);
        this.assertPropertyPath("foos[1].foos", constraints);
    }

    public void testNullElementInCollection() {
        try {
            this.getValidator().validate(null, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        RecursiveFoo foo = new RecursiveFoo();
        foo.getFoos().add(new RecursiveFoo());
        foo.getFoos().add(null);
        Assert.assertTrue((!this.getValidator().validate((Object)foo, new Class[0]).isEmpty() ? 1 : 0) != 0);
    }

    public void testGroups() {
        Validator validator = this.getValidator();
        Author author = new Author();
        author.setCompany("ACME");
        Book book = new Book();
        book.setTitle("");
        book.setAuthor(author);
        boolean foundTitleConstraint = false;
        Set constraintViolations = validator.validate((Object)book, new Class[]{Book.All.class});
        ValidationTest.assertEquals((int)1, (int)constraintViolations.size());
        for (ConstraintViolation constraintViolation : constraintViolations) {
            if (constraintViolation.getRootBean().getClass() != Book.class) continue;
            Assert.assertEquals((String)"may not be empty", (String)constraintViolation.getMessage());
            Assert.assertTrue((book == constraintViolation.getRootBean() ? 1 : 0) != 0);
            if (!constraintViolation.getPropertyPath().toString().equals("title")) continue;
            foundTitleConstraint = true;
            Assert.assertEquals((Object)book.getTitle(), (Object)constraintViolation.getInvalidValue());
        }
        Assert.assertTrue((boolean)foundTitleConstraint);
    }

    public void testConstraintValidatorContextFluentAPI() {
        Address ad = new Address();
        ad.setCity("error");
        ad.setZipCode("error");
        ad.setAddressline1("something");
        ad.setCountry(new Country());
        ad.getCountry().setName("something");
        Validator v = this.getValidator();
        Set violations = v.validate((Object)ad, new Class[0]);
        Assert.assertEquals((int)2, (int)violations.size());
        for (ConstraintViolation each : violations) {
            Assert.assertTrue((boolean)each.getMessage().endsWith(" not OK"));
        }
        ValidationTest.assertNotNull((Object)TestUtils.getViolation(violations, "city"));
        ValidationTest.assertNotNull((Object)TestUtils.getViolation(violations, ""));
    }

    public void testValidateNestedPropertyPath() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String propPath = "addresses[0].country.ISO2Code";
        Validator v = this.getValidator();
        Author author = new Author();
        author.setAddresses(new ArrayList<Address>());
        Address adr = new Address();
        author.getAddresses().add(adr);
        Country country = new Country();
        adr.setCountry(country);
        country.setISO2Code("too_long");
        Set iv = v.validateProperty((Object)author, "addresses[0].country.ISO2Code", new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        country.setISO2Code("23");
        iv = v.validateProperty((Object)author, "addresses[0].country.ISO2Code", new Class[0]);
        Assert.assertEquals((int)0, (int)iv.size());
        iv = v.validateValue(Author.class, "addresses[0].country.ISO2Code", (Object)"345", new Class[0]);
        Assert.assertEquals((int)1, (int)iv.size());
        iv = v.validateValue(Author.class, "addresses[0].country.ISO2Code", (Object)"34", new Class[0]);
        Assert.assertEquals((int)0, (int)iv.size());
    }

    public void testMetadataAPI() {
        Validator bookValidator = this.getValidator();
        BeanDescriptor bookBeanDescriptor = bookValidator.getConstraintsForClass(Book.class);
        Assert.assertFalse((boolean)bookBeanDescriptor.hasConstraints());
        Assert.assertTrue((boolean)bookBeanDescriptor.isBeanConstrained());
        Assert.assertTrue((bookBeanDescriptor.getConstraintDescriptors().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)4, (int)bookBeanDescriptor.getConstrainedProperties().size());
        Assert.assertTrue((bookBeanDescriptor.getConstraintsForProperty("doesNotExist") == null ? 1 : 0) != 0);
        Assert.assertTrue((bookBeanDescriptor.getConstraintsForProperty("description") == null ? 1 : 0) != 0);
        PropertyDescriptor propertyDescriptor = bookBeanDescriptor.getConstraintsForProperty("title");
        Assert.assertEquals((int)2, (int)propertyDescriptor.getConstraintDescriptors().size());
        Assert.assertTrue((boolean)"title".equals(propertyDescriptor.getPropertyName()));
        Iterator iter = propertyDescriptor.getConstraintDescriptors().iterator();
        ConstraintDescriptor constraintDescriptor = null;
        while (iter.hasNext() && !(constraintDescriptor = (ConstraintDescriptor)iter.next()).getAnnotation().annotationType().equals(NotNull.class)) {
        }
        Assert.assertTrue((constraintDescriptor != null ? 1 : 0) != 0);
        Assert.assertTrue((constraintDescriptor.getGroups().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals(NotNullValidator.class, constraintDescriptor.getConstraintValidatorClasses().get(0));
        propertyDescriptor = bookBeanDescriptor.getConstraintsForProperty("subtitle");
        Iterator iterator = propertyDescriptor.getConstraintDescriptors().iterator();
        constraintDescriptor = (ConstraintDescriptor)iterator.next();
        Assert.assertTrue((boolean)constraintDescriptor.getAnnotation().annotationType().equals(Size.class));
        Assert.assertTrue(((Integer)constraintDescriptor.getAttributes().get("max") == 30 ? 1 : 0) != 0);
        Assert.assertTrue((constraintDescriptor.getGroups().size() == 1 ? 1 : 0) != 0);
        propertyDescriptor = bookBeanDescriptor.getConstraintsForProperty("author");
        Assert.assertTrue((propertyDescriptor.getConstraintDescriptors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)propertyDescriptor.isCascaded());
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }
}

