/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.Locale;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.metadata.BeanDescriptor;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.jsr303.DefaultMessageInterpolator;

public class ExceptionsContractTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    private Validator getValidator() {
        return factory.getValidator();
    }

    public void testExceptionThrowingBean() {
        Validator validator = this.getValidator();
        try {
            validator.validate((Object)new ExceptionThrowingBean(), new Class[0]);
            Assert.fail((String)"No exception thrown when validating a bean whose getter throws a RTE");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void testValidateNullGroup() {
        Validator validator = this.getValidator();
        try {
            Class[] groups = null;
            validator.validate((Object)new String(), groups);
            Assert.fail((String)"No exception thrown when passing null as group array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateInvalidPropertyName() {
        Validator validator = this.getValidator();
        try {
            validator.validateProperty((Object)new Person(), null, new Class[0]);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            validator.validateProperty((Object)new Person(), "", new Class[0]);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            validator.validateProperty((Object)new Person(), "surname", new Class[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidatePropertyOnNullBean() {
        Validator validator = this.getValidator();
        try {
            validator.validateProperty(null, "class", new Class[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidatePropertyNullGroup() {
        Validator validator = this.getValidator();
        try {
            Class[] groups = null;
            validator.validateProperty((Object)new Person(), "name", groups);
            Assert.fail((String)"No exception thrown when passing null as group array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateValueOnNullClass() {
        Validator validator = this.getValidator();
        try {
            validator.validateValue(null, "class", Object.class, new Class[0]);
            Assert.fail((String)"No exception thrown when passing null as group array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateValueInvalidPropertyName() {
        Validator validator = this.getValidator();
        try {
            validator.validateValue(Person.class, null, (Object)"John", new Class[0]);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            validator.validateValue(Person.class, "", (Object)"John", new Class[0]);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            validator.validateValue(Person.class, "unexistant", (Object)"John", new Class[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateValueNullGroup() {
        Validator validator = this.getValidator();
        try {
            Class[] groups = null;
            validator.validateValue(Person.class, "name", (Object)"John", groups);
            Assert.fail((String)"No exception thrown when passing null as group array");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetConstraintsForInvalidProperty() {
        Validator validator = this.getValidator();
        BeanDescriptor personDescriptor = validator.getConstraintsForClass(Person.class);
        try {
            personDescriptor.getConstraintsForProperty(null);
            ExceptionsContractTest.fail((String)"No exception thrown when calling getConstraintsForProperty with null property");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            personDescriptor.getConstraintsForProperty("");
            ExceptionsContractTest.fail((String)"No exception thrown when calling getConstraintsForProperty with empty property");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    public static class Person {
        @NotNull
        public String name;
    }

    public static class ExceptionThrowingBean {
        @NotNull
        public String getValue() {
            throw new IllegalStateException();
        }
    }
}

