/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Payload;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import junit.framework.TestCase;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;

public class CustomConstraintValidatorFactoryTest
extends TestCase {
    public void testValidationExceptionWhenFactoryReturnsNullValidator() {
        ConstraintValidatorFactory customFactory = new ConstraintValidatorFactory(){

            public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
                return null;
            }
        };
        ApacheValidatorConfiguration customConfig = (ApacheValidatorConfiguration)((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).constraintValidatorFactory(customFactory);
        Validator validator = customConfig.buildValidatorFactory().getValidator();
        try {
            validator.validate((Object)new Person(), new Class[0]);
            CustomConstraintValidatorFactoryTest.fail((String)"ValidationException must be thrown when factory returns a null constraint validator.");
        }
        catch (ValidationException e) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Constraint(validatedBy={GoodPersonValidator.class})
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface GoodPerson {
        public String message() default "Not a good person";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class GoodPersonValidator
        implements ConstraintValidator<GoodPerson, Person> {
            public void initialize(GoodPerson constraintAnnotation) {
            }

            public boolean isValid(Person value, ConstraintValidatorContext context) {
                return true;
            }
        }
    }

    @GoodPerson
    public static class Person {
    }
}

