/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintViolation;
import javax.validation.OverridesAttribute;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.jsr303.DefaultMessageInterpolator;

public class ConstraintCompositionTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    private Validator getValidator() {
        return factory.getValidator();
    }

    public void test1LevelInheritance() {
        Validator validator = this.getValidator();
        Set violations = validator.validate((Object)new Person(), new Class[0]);
        Assert.assertEquals((String)"Wrong number of violations detected", (int)1, (int)violations.size());
        String msg = ((ConstraintViolation)violations.iterator().next()).getMessage();
        Assert.assertEquals((String)"Incorrect violation message", (String)"A person needs a non null name", (String)msg);
        violations = validator.validate((Object)new Person(), new Class[]{Group1.class});
        Assert.assertEquals((String)"Wrong number of violations detected", (int)0, (int)violations.size());
    }

    public void test2LevelInheritance() {
        Validator validator = this.getValidator();
        Set violations = validator.validate((Object)new Man(), new Class[0]);
        Assert.assertEquals((String)"Wrong number of violations detected", (int)0, (int)violations.size());
        violations = validator.validate((Object)new Man(), new Class[]{Group1.class});
        Assert.assertEquals((String)"Wrong number of violations detected", (int)1, (int)violations.size());
        String msg = ((ConstraintViolation)violations.iterator().next()).getMessage();
        Assert.assertEquals((String)"Incorrect violation message", (String)"A person needs a non null name", (String)msg);
    }

    public void testAnnotationGroupsAreInherited() {
        Validator validator = this.getValidator();
        ConstraintDescriptor manNameDesc = (ConstraintDescriptor)this.getValidator().getConstraintsForClass(Man.class).getConstraintsForProperty("name").getConstraintDescriptors().iterator().next();
        ConstraintDescriptor personNameDesc = (ConstraintDescriptor)manNameDesc.getComposingConstraints().iterator().next();
        ConstraintDescriptor notNullDesc = (ConstraintDescriptor)personNameDesc.getComposingConstraints().iterator().next();
        Assert.assertEquals((String)"There should only be 1 group", (int)1, (int)manNameDesc.getGroups().size());
        Assert.assertTrue((String)"Group1 should be present", (boolean)manNameDesc.getGroups().contains(Group1.class));
        Assert.assertEquals((String)"There should only be 1 group", (int)1, (int)personNameDesc.getGroups().size());
        Assert.assertTrue((String)"Group1 should be present", (boolean)personNameDesc.getGroups().contains(Group1.class));
        Assert.assertEquals((String)"There should only be 1 group", (int)1, (int)personNameDesc.getGroups().size());
        Assert.assertTrue((String)"Group1 should be present", (boolean)notNullDesc.getGroups().contains(Group1.class));
        Set violations = validator.validate((Object)new Man(), new Class[]{Group1.class});
        Set notNullGroups = ((ConstraintViolation)violations.iterator().next()).getConstraintDescriptor().getGroups();
        Assert.assertEquals((String)"There should only be 1 group", (int)1, (int)notNullGroups.size());
        Assert.assertTrue((String)"Group1 should be the only group", (boolean)notNullGroups.contains(Group1.class));
    }

    public void testAnnotationPayloadsAreInherited() {
        Validator validator = this.getValidator();
        ConstraintDescriptor manNameDesc = (ConstraintDescriptor)this.getValidator().getConstraintsForClass(Man.class).getConstraintsForProperty("name").getConstraintDescriptors().iterator().next();
        ConstraintDescriptor personNameDesc = (ConstraintDescriptor)manNameDesc.getComposingConstraints().iterator().next();
        ConstraintDescriptor notNullDesc = (ConstraintDescriptor)personNameDesc.getComposingConstraints().iterator().next();
        Assert.assertEquals((String)"There should only be 1 payload class", (int)1, (int)manNameDesc.getPayload().size());
        Assert.assertTrue((String)"Payload1 should be present", (boolean)manNameDesc.getPayload().contains(Payload1.class));
        Assert.assertEquals((String)"There should only be 1 payload class", (int)1, (int)personNameDesc.getPayload().size());
        Assert.assertTrue((String)"Payload1 should be present", (boolean)personNameDesc.getPayload().contains(Payload1.class));
        Assert.assertEquals((String)"There should only be 1 payload class", (int)1, (int)personNameDesc.getPayload().size());
        Assert.assertTrue((String)"Payload1 should be present", (boolean)notNullDesc.getPayload().contains(Payload1.class));
        Set violations = validator.validate((Object)new Man(), new Class[]{Group1.class});
        Set notNullPayload = ((ConstraintViolation)violations.iterator().next()).getConstraintDescriptor().getPayload();
        Assert.assertEquals((String)"There should only be 1 payload class", (int)1, (int)notNullPayload.size());
        Assert.assertTrue((String)"Payload1 should be the only payload", (boolean)notNullPayload.contains(Payload1.class));
    }

    public void testIndexedOverridesAttributes() {
        Validator validator = this.getValidator();
        Person p = new Person();
        p.name = "valid";
        p.id = "1234";
        Set constraintViolations = validator.validate((Object)p, new Class[0]);
        Assert.assertTrue((String)"No violations should be reported on valid id", (boolean)constraintViolations.isEmpty());
        p.id = "1";
        constraintViolations = validator.validate((Object)p, new Class[0]);
        Assert.assertEquals((String)"Only 1 violation expected", (int)1, (int)constraintViolations.size());
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)"Wrong violation", (String)"Id is too short", (String)violation.getMessage());
        p.id = "loooooong id";
        constraintViolations = validator.validate((Object)p, new Class[0]);
        Assert.assertEquals((String)"Only 1 violation expected", (int)1, (int)constraintViolations.size());
        violation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)"Wrong violation", (String)"Id is too long", (String)violation.getMessage());
    }

    public void testReportAsAsingleViolation() {
        Validator validator = this.getValidator();
        Code c = new Code();
        c.code = "very invalid code";
        Set constraintViolations = validator.validate((Object)c, new Class[0]);
        Assert.assertEquals((String)"Only 1 violation expected", (int)1, (int)constraintViolations.size());
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)"Wrong violation message", (String)"Invalid code", (String)violation.getMessage());
        Assert.assertEquals((String)"Wrong violation type", ElevenDigitsCode.class, violation.getConstraintDescriptor().getAnnotation().annotationType());
    }

    static {
        ((DefaultMessageInterpolator)factory.getMessageInterpolator()).setLocale(Locale.ENGLISH);
    }

    public static class Payload2
    implements Payload {
    }

    public static class Payload1
    implements Payload {
    }

    public static interface Group2 {
    }

    public static interface Group1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Size(min=11, max=11)
    @Pattern(regexp="\\d*")
    @Constraint(validatedBy={})
    @ReportAsSingleViolation
    @Documented
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ElevenDigitsCode {
        public String message() default "Invalid code";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Size.List(value={@Size(min=3, max=3, message="Id is too short"), @Size(min=5, max=5, message="Id is too long")})
    @Constraint(validatedBy={})
    @Documented
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PersonId {
        public String message() default "Wrong person id";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        @OverridesAttribute(constraint=Size.class, constraintIndex=0, name="max")
        public int maxSize() default 1000;

        @OverridesAttribute(constraint=Size.class, constraintIndex=1, name="min")
        public int minSize() default 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PersonName(groups={Group2.class}, payload={Payload1.class, Payload2.class})
    @Constraint(validatedBy={})
    @Documented
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ManName {
        public String message() default "Wrong man name";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotNull(message="A person needs a non null name", groups={Group1.class}, payload={})
    @Constraint(validatedBy={})
    @Documented
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PersonName {
        public String message() default "Wrong person name";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static class Code {
        @ElevenDigitsCode
        String code;
    }

    public static class Man {
        @ManName(groups={Group1.class}, payload={Payload1.class})
        String name;
    }

    public static class Person {
        @PersonName
        String name;
        @PersonId
        String id;
    }
}

