/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.bval.jsr303.example.CompanyAddress;
import org.apache.bval.jsr303.example.FrenchAddress;
import org.apache.bval.jsr303.util.TestUtils;

public class ComposedConstraintsTest
extends TestCase {
    static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    public void testMetaDataAPI_ComposedConstraints() {
        Validator addressValidator = factory.getValidator();
        PropertyDescriptor ed = addressValidator.getConstraintsForClass(FrenchAddress.class).getConstraintsForProperty("zipCode");
        Assert.assertEquals((int)1, (int)ed.getConstraintDescriptors().size());
        for (ConstraintDescriptor cd : ed.getConstraintDescriptors()) {
            Assert.assertTrue((boolean)cd.isReportAsSingleViolation());
            Assert.assertEquals((int)3, (int)cd.getComposingConstraints().size());
            Assert.assertTrue((String)"no composing constraints found!!", (!cd.getComposingConstraints().isEmpty() ? 1 : 0) != 0);
            this.processConstraintDescriptor(cd);
        }
    }

    public void processConstraintDescriptor(ConstraintDescriptor cd) {
        if (cd.getAnnotation().annotationType().equals(Size.class)) {
            Size m = (Size)cd.getAnnotation();
        }
        for (Object composingCd : cd.getComposingConstraints()) {
            this.processConstraintDescriptor((ConstraintDescriptor)composingCd);
        }
    }

    public void testValidateComposed() {
        FrenchAddress adr = new FrenchAddress();
        Validator val = factory.getValidator();
        Set findings = val.validate((Object)adr, new Class[0]);
        Assert.assertEquals((int)1, (int)findings.size());
        ConstraintViolation finding = (ConstraintViolation)findings.iterator().next();
        Assert.assertEquals((String)"Wrong zipcode", (String)finding.getMessage());
        adr.setZipCode("1234567");
        findings = val.validate((Object)adr, new Class[0]);
        Assert.assertEquals((int)0, (int)findings.size());
        adr.setZipCode("1234567234567");
        findings = val.validate((Object)adr, new Class[0]);
        Assert.assertTrue((findings.size() > 0 ? 1 : 0) != 0);
    }

    public void testOverridesAttributeConstraintIndex() {
        CompanyAddress adr = new CompanyAddress("invalid-string");
        Validator val = factory.getValidator();
        Set findings = val.validate((Object)adr, new Class[0]);
        ComposedConstraintsTest.assertEquals((int)2, (int)findings.size());
        ComposedConstraintsTest.assertNotNull((Object)TestUtils.getViolationWithMessage(findings, "Not COMPANY"));
        ComposedConstraintsTest.assertNotNull((Object)TestUtils.getViolationWithMessage(findings, "Not an email"));
        adr = new CompanyAddress("JOHN_DO@WEB.DE");
        findings = val.validate((Object)adr, new Class[0]);
        ComposedConstraintsTest.assertEquals((int)1, (int)findings.size());
        ComposedConstraintsTest.assertNotNull((Object)TestUtils.getViolationWithMessage(findings, "Not COMPANY"));
        adr = new CompanyAddress("JOHN_DO@COMPANY.DE");
        findings = val.validate((Object)adr, new Class[0]);
        Assert.assertTrue((boolean)findings.isEmpty());
    }
}

